//HEADER
/*
  fifoPopt-sliced.c 
  Copyright 2012-2013 Marc Prager
 
  This file is part of the c-any library.
  c-any is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 
  c-any is published in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License along with c-any.
  If not see <http://www.gnu.org/licenses/>
 */

#include <fifoPopt.h>
#include <fifoParse.h>
#include <fifoPrint.h>

//SLICE
bool fifoPoptScanOption(Fifo *argList, char shortOption, const char *longOption) {
	Fifo clone = *argList;
	while (fifoCanRead(&clone)) {
		Fifo option;
		if (fifoqParseHead(&clone,&option)) {
			if (fifoParseExactChar(&option,'-')
			&& (	fifoParseExactChar(&option,shortOption)
				|| fifoParseExactChar(&option,'-') && fifoParseExactString(&option,longOption)
			)) return true;
		}
		else return false;
	}
	return false;
}

//SLICE
bool fifoPoptAccumulateCommandLine(Fifo *argList, int argc, const char* const* argv) {
	bool success = true;
	for (int a=1; a<argc; a++) success = success && fifoqPrintString(argList,argv[a]);
	return success;
}

//SLICE
bool fifoPoptBool(Fifo *fifo, const FifoPoptBool *options) {
	Fifo clone = *fifo;
	if (fifoParseExactChar(&clone,'-')) {
		// either all accumulated options must be found or none
		bool foundAny = false;
		while (!fifoParseZ(&clone)) {
			bool found = false;
			for (int o=0; options[o].shortOption!=0; ++o) {
				if (fifoParseExactChar(&clone,options[o].shortOption)) {
					* options[o].value = true;
					found = true;
					foundAny = true;
					break;
				}
			}
			if (!found) return false;
		}

		if (foundAny) {
			fifoCopyReadPosition(fifo,&clone);
			return true;
		}
		else return false;	// no option found
	}
	return false;	// non-option. No violation
}

//SLICE
bool fifoPoptInt32(Fifo *fifo, const FifoPoptInt32 *options) {
	Fifo clone = *fifo;
	if (fifoParseExactChar(&clone,'-')) {
		for (int o=0; options[o].shortOption!=0; ++o) {
			if (fifoParseExactChar(&clone,options[o].shortOption)) {
				fifoParseZ(&clone);	// optional space(s)
				FifoParseInt32 parseInt	= options[o].parseInt!=0
							? options[o].parseInt : fifoParseIntCStyle;
				// option char present
				Int32 temp;
				if (parseInt(&clone,&temp)
				&& fifoParseZ(&clone)) {
					* options[o].value = temp;
					fifoCopyReadPosition(fifo,&clone);
					return true;	// there's only one option per -
				}
				else return false;	// parameter or spacing missing
			}
		}
		return false;	// no option found
	}
	else return false;	// non-option
}

//SLICE
bool fifoPoptInt32Range(Fifo *fifo, const FifoPoptInt32Range *options) {
	Fifo clone = *fifo;
	if (fifoParseExactChar(&clone,'-')) {
		for (int o=0; options[o].shortOption!=0; ++o) {
			if (fifoParseExactChar(&clone,options[o].shortOption)) {
				fifoParseZ(&clone);	// optional space(s)
				const FifoParseInt32 parseInt = options[o].parseInt!=0
							? options[o].parseInt : fifoParseIntCStyle;
				const char *separator = options[o].separator!=0 ? options[0].separator : "..";
				// option char present
				Int32 from,to;
				if (parseInt(&clone,&from)) {
					if (fifoParseZ(&clone)) {
						options[o].value->a = from;
						options[o].value->b = from;
						fifoCopyReadPosition(fifo,&clone);
						return true;
					}
					else if	(fifoParseExactString(&clone,separator)
						&& parseInt(&clone,&to)
						&& fifoParseZ(&clone)) {

						options[o].value->a = from;
						options[o].value->b = to;
						fifoCopyReadPosition(fifo,&clone);
						return true;
					}
					else return false;
				}
				// else not an integer
			}
		}
		return false;	// no option found
	}
	else return false;	// non-option
}

//SLICE
static bool fifoPoptInt32TupleConditional(Fifoq *cmdLine, const FifoPoptInt32Tuple *options, bool setValues) {
	if (fifoParseExactChar(cmdLine,'-')) {
		for (int o=0; options[o].shortOption!=0; ++o) {
			if (fifoParseExactChar(cmdLine,options[o].shortOption)) {
				// option found.
				fifoParseZ(cmdLine);	// optional space(s)
				FifoParseInt32 parseInt	= options[o].parseInt!=0
							? options[o].parseInt : fifoParseIntCStyle;
				for (int e=0; e<options[o].n; ++e) {	// n values
					// check for separator
					if (e!=0 && !fifoParseExactString(cmdLine,options[o].separator)) return false;
					// check for value
					Int32 temp;
					if (parseInt(cmdLine,&temp)) {
						if (setValues) options[o].values[e] = temp;
					}
					else return false;	// invalid value
				}
				return fifoParseZ(cmdLine);
			}
			// next option...
		}
		return false;	// no option found
	}
	else return false;	// non-option
}

bool fifoPoptInt32Tuple(Fifoq *cmdLine, const FifoPoptInt32Tuple *options) {
	Fifo clone = *cmdLine;
	if (fifoPoptInt32TupleConditional(&clone,options,false))
		return fifoPoptInt32TupleConditional(cmdLine,options,true);
	else return false;
}

//SLICE
bool fifoPoptString(Fifo *fifo, const FifoPoptString *options) {
	Fifo clone = *fifo;
	if (fifoParseExactChar(&clone,'-')) {
		for (int o=0; options[o].shortOption!=0; ++o) {
			if (fifoParseExactChar(&clone,options[o].shortOption)) {
				fifoParseZ(&clone);	// remove optional space, if any
				// option char present
				Fifo fifoWord;
				if (fifoParseStringZ(&clone,&fifoWord)) {
					* options[o].value = fifoWord;
					fifoCopyReadPosition(fifo,&clone);
					return true;
				}
				else return false;
			}
		}
		return false;	// no option found
	}
	return false;		// non-option
}

//SLICE
bool fifoPoptNonOptionAccumulate(Fifo *cmdLine, Fifo *listOfNonOptions) {
	if (fifoCanRead(cmdLine) && fifoLookAhead(cmdLine)!='-') {
		Fifo fifoString;
		if (fifoParseStringZ(cmdLine,&fifoString)) {
			return fifoAppend(listOfNonOptions,&fifoString) && fifoPrintChar(listOfNonOptions,0);
		}
		else return false;
	}
	else return false;
}

//SLICE
bool fifoPoptSymbol(Fifo *fifo, const FifoPoptSymbol *options) {
	Fifo clone = *fifo;
	if (fifoParseExactChar(&clone,'-')) {
		for (int o=0; options[o].shortOption!=0; ++o) {
			if (fifoParseExactChar(&clone,options[o].shortOption)) {
				fifoParseZ(&clone);	// remove optional space, if any
				// option char present
				for (int s=0; options[o].symbols[s]!=0; s++) {
					Fifo clone2 = clone;
					if (fifoParseExactString(&clone2,options[o].symbols[s])
					&& fifoParseZ(&clone2)) {
						* options[o].value = s;
						fifoCopyReadPosition(fifo,&clone2);
						return true;
					}
					// else no symbol match
				}
			}
			// else no option match
		}
		return false;	// no option found
	}
	return false;		// non-option
}

