// (C) Marc Prager, 2005..2008
#ifndef MACROS_H
#define MACROS_H

/** @file
 * @brief Basic macros: MIN,MAX,ABS,ELEMENTS and more.
 */

#define DIV_CEILING(x,y)	(((x)+(y)-1)/(y))
#define DIV_ROUND(x,y)		(((x)+(y)/2)/(y))

#define ALIGN(align,x)		(DIV_CEILING(x,align)*align)
#define ALIGN8(x)		ALIGN(x,8)

#define ELEMENTS(x)		(sizeof(x)/sizeof(x[0]))

#define MIN(x,y) ((x)<(y) ? (x) : (y))
#define MAX(x,y) ((x)>(y) ? (x) : (y))

#define MINMAX(a,b,x) ((x)<(a) ? (a) : ((b)<(x) ? (b) : (x)))
#define ABS(x) ((x)>=0 ? (x) : (-(x)))

#endif
