//HEADER
#include <symbolTable.h>

//SLICE
bool streq(const char *a, const char *b) {
	for ( ;*a!=0 && *b!=0; ++a, ++b) if (*a!=*b) return false;

	return true;
}

//SLICE
bool symbolLookUp(const SymbolAssoc symbolTable[], const char *symbol, int *value) {
	if (symbol==0 || symbol[0]==0) return false;
	for (int s=0; symbolTable[s].symbol!=0; ++s) if (streq(symbol,symbolTable[s].symbol)) {
		*value = symbolTable[s].value;
		return true;
	}
	return false;
}

