#ifndef __symbolTable_h
#define __symbolTable_h

/** @file
 * @brief Mapping symbols to integer values.
 */

#include <stdbool.h>

/** Symbol-value-pair to create symbol tables.
 */
typedef struct {
	const char *	symbol;		///< symbol, 0 at end of list
	int		value;		///< numeric constant
} SymbolAssoc;

/** Simple string compare.
 * @param a first string.
 * @param b second string.
 * @return true, if a and b are equal, false otherwise.
 */
bool streq(const char *a, const char *b);

/** Looks up the (numeric) value of a symbol.
 * @param symbolTable a { 0 } - terminated array of symbol-value pairs.
 * @param symbol the symbol to look for
 * @param value a pointer to the location where to store the result in case of success.
 * @return true if symbol is found, false otherwise (and value unchanged).
 */
bool symbolLookUp(const SymbolAssoc symbolTable[], const char *symbol, int *value);

#endif
