/*
  font8x8.c 
  Copyright not owned by Marc Prager - I forgot, from which open source I extracted the pixels. Shame on me.
 
  This file is part of the c-any library.
  c-any is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 
  c-any is published in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License along with c-any.
  If not see <http://www.gnu.org/licenses/>
 */
/* System 8x8 (char 0 .. #32 to #127) */

#include <fonts.h>

static const unsigned char fontData[128 *8]= {		// limited to ASCII
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, // padding
 0,   0,   0,   0,   0,   0,   0,   0, //' '
 0,   6,  95,  95,   6,   0,   0,   0, //'!'
 0,   7,   7,   0,   7,   7,   0,   0, //'"'
20, 127, 127,  20, 127, 127,  20,   0, //'#'
36,  46, 107, 107,  58,  18,   0,   0, //'$'
70, 102,  48,  24,  12, 102,  98,   0, //'%'
48, 122,  79,  93,  55, 122,  72,   0, //'&'
 4,   7,   3,   0,   0,   0,   0,   0, //'''
 0,  28,  62,  99,  65,   0,   0,   0, //'('
 0,  65,  99,  62,  28,   0,   0,   0, //')'
 8,  42,  62,  28,  28,  62,  42,   0, //'*'
 8,   8,  62,  62,   8,   8,   0,   0, //'+'
 0, 128, 224,  96,   0,   0,   0,   0, //','
 8,   8,   8,   8,   8,   8,   0,   0, //'-'
 0,   0,  96,  96,   0,   0,   0,   0, //'.'
96,  48,  24,  12,   6,   3,   1,   0, //'/'
62, 127, 113,  89,  77, 127,  62,   0, //'0'
64,  66, 127, 127,  64,  64,   0,   0, //'1'
98, 115,  89,  73, 111, 102,   0,   0, //'2'
34,  99,  73,  73, 127,  54,   0,   0, //'3'
24,  28,  22,  83, 127, 127,  80,   0, //'4'
39, 103,  69,  69, 125,  57,   0,   0, //'5'
60, 126,  75,  73, 121,  48,   0,   0, //'6'
 3,   3, 113, 121,  15,   7,   0,   0, //'7'
54, 127,  73,  73, 127,  54,   0,   0, //'8'
 6,  79,  73, 105,  63,  30,   0,   0, //'9'
 0,   0, 102, 102,   0,   0,   0,   0, //':'
 0, 128, 230, 102,   0,   0,   0,   0, //';'
 8,  28,  54,  99,  65,   0,   0,   0, //'<'
36,  36,  36,  36,  36,  36,   0,   0, //'='
 0,  65,  99,  54,  28,   8,   0,   0, //'>'
 2,   3,  81,  89,  15,   6,   0,   0, //'?'
62, 127,  65,  93,  93,  31,  30,   0, //'@'
124, 126,  19,  19, 126, 124,   0,   0, //'A'
65, 127, 127,  73,  73, 127,  54,   0, //'B'
28,  62,  99,  65,  65,  99,  34,   0, //'C'
65, 127, 127,  65,  99,  62,  28,   0, //'D'
65, 127, 127,  73,  93,  65,  99,   0, //'E'
65, 127, 127,  73,  29,   1,   3,   0, //'F'
28,  62,  99,  65,  81, 115, 114,   0, //'G'
127, 127,   8,   8, 127, 127,   0,  0, //'H'
 0,  65, 127, 127,  65,   0,   0,   0, //'I'
48, 112,  64,  65, 127,  63,   1,   0, //'J'
65, 127, 127,   8,  28, 119,  99,   0, //'K'
65, 127, 127,  65,  64,  96, 112,   0, //'L'
127, 127,  14,  28,  14, 127, 127,   0, //'M'
127, 127,   6,  12,  24, 127, 127,   0, //'N'
28,  62,  99,  65,  99,  62,  28,   0, //'O'
65, 127, 127,  73,   9,  15,   6,   0, //'P'
30,  63,  33, 113, 127,  94,   0,   0, //'Q'
65, 127, 127,   9,  25, 127, 102,   0, //'R'
38, 111,  77,  89, 115,  50,   0,   0, //'S'
 3,  65, 127, 127,  65,   3,   0,   0, //'T'
127, 127,  64,  64, 127, 127,   0,   0, //'U'
31,  63,  96,  96,  63,  31,   0,   0, //'V'
127, 127,  48,  24,  48, 127, 127,   0, //'W'
67, 103,  60,  24,  60, 103,  67,   0, //'X'
 7,  79, 120, 120,  79,   7,   0,   0, //'Y'
71,  99, 113,  89,  77, 103, 115,   0, //'Z'
 0, 127, 127,  65,  65,   0,   0,   0, //'['
 1,   3,   6,  12,  24,  48,  96,   0, //'\'
 0,  65,  65, 127, 127,   0,   0,   0, //']'
 8,  12,   6,   3,   6,  12,   8,   0, //'^'
128, 128, 128, 128, 128, 128, 128,   0, //'_'
 0,   0,   3,   7,   4,   0,   0,   0, //'`'
32, 116,  84,  84,  60, 120,  64,   0, //'a'
65, 127,  63,  72,  72, 120,  48,   0, //'b'
56, 124,  68,  68, 108,  40,   0,   0, //'c'
48, 120,  72,  73,  63, 127,  64,   0, //'d'
56, 124,  84,  84,  92,  24,   0,   0, //'e'
72, 126, 127,  73,   3,   2,   0,   0, //'f'
56, 188, 164, 164, 252, 120,   0,   0, //'g'
65, 127, 127,   8,   4, 124, 120,   0, //'h'
 0,  68, 125, 125,  64,   0,   0,   0, //'i'
96, 224, 128, 128, 253, 125,   0,   0, //'j'
65, 127, 127,  16,  56, 108,  68,   0, //'k'
 0,  65, 127, 127,  64,   0,   0,   0, //'l'
120, 124,  28,  56,  28, 124, 120,   0, //'m'
124, 124,   4,   4, 124, 120,   0,   0, //'n'
56, 124,  68,  68, 124,  56,   0,   0, //'o'
0, 252, 252, 164,  36,  60,  24,    0,//'p'
24,  60,  36, 164, 248, 252, 132,   0, //'q'
68, 124, 120,  76,   4,  28,  24,   0, //'r'
72,  92,  84,  84, 116,  36,   0,   0, //'s'
 0,   4,  62, 127,  68,  36,   0,   0, //'t'
60, 124,  64,  64,  60, 124,  64,   0, //'u'
28,  60,  96,  96,  60,  28,   0,   0, //'v'
60, 124, 112,  56, 112, 124,  60,   0, //'w'
68, 108,  56,  16,  56, 108,  68,   0, //'x'
60, 188, 160, 160, 252, 124,   0,   0, //'y'
76, 100, 116,  92,  76, 100,   0,   0, //'z'
 8,   8,  62, 119,  65,  65,   0,   0, //'{'
 0,   0,   0, 119, 119,   0,   0,   0, //'|'
65,  65, 119,  62,   8,   8,   0,   0, //'}'
 2,   3,   1,   3,   2,   3,   1,   0, //'~'
255, 129,  129,  129,  129, 129,    0,255, //''
};

static const Gfxmono imageBuffer= {
	sizeof fontData, 8,  8,1,  (void*) fontData	// width = sizeof fontData /8[byte/char]*8 [pixel per char]
};

static CharLocation charLocation(char c) {
	const CharLocation charLocation = { c*8, 0, 8 };

	return charLocation;
}

static CharLocation charLocationV(char c) {
	return fontCharLocationVariableLength(&font8x8,c,4,1);
}

const Font font8x8 = { &imageBuffer, 8, &charLocation };
const Font font8x8V = { &imageBuffer, 8, &charLocationV };

