#include <int32Integrator.h>

void int32IntegratorMove(Int32Integrator *i, Int32 dxdtMin, Int32 dxdtMax, Int32 xTo) {
	const Int64 deltaX_e32 = ((Int64)xTo<<32) - i->q.value_e32;

	if (deltaX_e32>=0) {
		const Q3232 ldx = int32ScaleValue(i->time, dxdtMax);
		i->q.value_e32 += deltaX_e32<=ldx.value_e32 ? deltaX_e32 : ldx.value_e32;
	}
	else {
		const Q3232 ldx = int32ScaleValue(i->time, dxdtMin);
		i->q.value_e32 += deltaX_e32>=ldx.value_e32 ? deltaX_e32 : ldx.value_e32;
	}
}

