#ifndef __parse_h
#define __parse_h

/** @file
 * @brief Character classification functions.
 */

#include <stdbool.h>

/** Check for a digit.
 * @param c character
 * @return true, if c is in the range '0'..'9'.
 */
bool isDigit(char c);

/** Checks for a hexadecimal digit.
 * @param c character
 * @return true, if c is in the range '0'..'9', 'a'..'f', 'A'..'F'
 */
bool isHexDigit(char c);

/** Check for a letter.
 * @param c character
 * @return true, if c is in the range 'a'..'z' or 'A'..'Z'.
 */
bool isAlpha(char c);

/** Check for a space character.
 * @param c character
 * @return true, if c is one of ' ', '\\t'
 */
bool isBlank(char c);

/** Check for a space character.
 * @param c character
 * @return true, if c is one of ' ', '\\t', '\\f', '\\r', '\\n', ...
 */
bool isSpace(char c);

/** Converts a dec, hex or baseN digit to an integer.
 * @param baseNDigit a digit or uppercase/lowercase character.
 * @return the numeric value of the digit
 */
int baseNDigitToInt(char baseNDigit);

#endif
