//HEADER
#include <parse.h>
#include <string.h>


//SLICE
bool isDigit(char c) {
	return '0'<=c && c<='9';
}

//SLICE
bool isHexDigit(char c) {
	return	'0'<=c && c<='9'
		|| 'a'<=c && c<='f'
		|| 'A'<=c && c<='F';
}

//SLICE
bool isAlpha(char c) {
	return 'a'<=c && c<='z' || 'A'<=c && c<='Z';
}

//SLICE
bool isBlank(char c) {
	switch(c) {
		case ' ':
		case '\t': return true;
		default: return false;
	}
}

//SLICE
bool isSpace(char c) {
	switch(c) {
		case ' ':
		case '\t':
		case '\r':
		case '\n':
		case '\f': return true;
		default: return false;
	}
}

//SLICE
int baseNDigitToInt(char c) {
	if ('0'<=c && c<='9') return c-'0';
	else if ('A'<=c && c<='Z') return c-'A'+0xA;
	else return c-'a'+0xa;
}

