//HEADER
/*
  physics.c
  Copyright 2011 Marc Prager
 
  This file is part of the c-any library.
  c-any is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 
  c-any is published in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License along with c-any.
  If not see <http://www.gnu.org/licenses/>
 */

#include <physics.h>
#include <integers.h>
#include <macros.h>

//SLICE
static Uint16 h2oTable[] = {
// H2O pressure table, unsigned int 0..269 to pressure in mbar=hPa as uint16_t
// formula: hPa(c) = 6.112E-3 * exp(17.67*c/(c+243.5))
	6,	// T=0 Celsius
	7,	// T=1 Celsius
	7,	// T=2 Celsius
	8,	// T=3 Celsius
	8,	// T=4 Celsius
	9,	// T=5 Celsius
	9,	// T=6 Celsius
	10,	// T=7 Celsius
	11,	// T=8 Celsius
	11,	// T=9 Celsius
	12,	// T=10 Celsius
	13,	// T=11 Celsius
	14,	// T=12 Celsius
	15,	// T=13 Celsius
	16,	// T=14 Celsius
	17,	// T=15 Celsius
	18,	// T=16 Celsius
	19,	// T=17 Celsius
	21,	// T=18 Celsius
	22,	// T=19 Celsius
	23,	// T=20 Celsius
	25,	// T=21 Celsius
	26,	// T=22 Celsius
	28,	// T=23 Celsius
	30,	// T=24 Celsius
	32,	// T=25 Celsius
	34,	// T=26 Celsius
	36,	// T=27 Celsius
	38,	// T=28 Celsius
	40,	// T=29 Celsius
	42,	// T=30 Celsius
	45,	// T=31 Celsius
	48,	// T=32 Celsius
	50,	// T=33 Celsius
	53,	// T=34 Celsius
	56,	// T=35 Celsius
	60,	// T=36 Celsius
	63,	// T=37 Celsius
	66,	// T=38 Celsius
	70,	// T=39 Celsius
	74,	// T=40 Celsius
	78,	// T=41 Celsius
	82,	// T=42 Celsius
	87,	// T=43 Celsius
	91,	// T=44 Celsius
	96,	// T=45 Celsius
	101,	// T=46 Celsius
	107,	// T=47 Celsius
	112,	// T=48 Celsius
	118,	// T=49 Celsius
	124,	// T=50 Celsius
	130,	// T=51 Celsius
	137,	// T=52 Celsius
	144,	// T=53 Celsius
	151,	// T=54 Celsius
	159,	// T=55 Celsius
	166,	// T=56 Celsius
	175,	// T=57 Celsius
	183,	// T=58 Celsius
	192,	// T=59 Celsius
	201,	// T=60 Celsius
	211,	// T=61 Celsius
	221,	// T=62 Celsius
	231,	// T=63 Celsius
	242,	// T=64 Celsius
	253,	// T=65 Celsius
	265,	// T=66 Celsius
	277,	// T=67 Celsius
	289,	// T=68 Celsius
	302,	// T=69 Celsius
	316,	// T=70 Celsius
	330,	// T=71 Celsius
	345,	// T=72 Celsius
	360,	// T=73 Celsius
	376,	// T=74 Celsius
	392,	// T=75 Celsius
	409,	// T=76 Celsius
	426,	// T=77 Celsius
	445,	// T=78 Celsius
	463,	// T=79 Celsius
	483,	// T=80 Celsius
	503,	// T=81 Celsius
	524,	// T=82 Celsius
	546,	// T=83 Celsius
	568,	// T=84 Celsius
	591,	// T=85 Celsius
	615,	// T=86 Celsius
	640,	// T=87 Celsius
	666,	// T=88 Celsius
	692,	// T=89 Celsius
	720,	// T=90 Celsius
	748,	// T=91 Celsius
	777,	// T=92 Celsius
	807,	// T=93 Celsius
	839,	// T=94 Celsius
	871,	// T=95 Celsius
	904,	// T=96 Celsius
	938,	// T=97 Celsius
	974,	// T=98 Celsius
	1010,	// T=99 Celsius
	1048,	// T=100 Celsius
	1087,	// T=101 Celsius
	1126,	// T=102 Celsius
	1168,	// T=103 Celsius
	1210,	// T=104 Celsius
	1254,	// T=105 Celsius
	1299,	// T=106 Celsius
	1345,	// T=107 Celsius
	1393,	// T=108 Celsius
	1443,	// T=109 Celsius
	1493,	// T=110 Celsius
	1545,	// T=111 Celsius
	1599,	// T=112 Celsius
	1654,	// T=113 Celsius
	1711,	// T=114 Celsius
	1770,	// T=115 Celsius
	1830,	// T=116 Celsius
	1891,	// T=117 Celsius
	1955,	// T=118 Celsius
	2020,	// T=119 Celsius
	2087,	// T=120 Celsius
	2156,	// T=121 Celsius
	2227,	// T=122 Celsius
	2299,	// T=123 Celsius
	2374,	// T=124 Celsius
	2451,	// T=125 Celsius
	2529,	// T=126 Celsius
	2610,	// T=127 Celsius
	2693,	// T=128 Celsius
	2778,	// T=129 Celsius
	2865,	// T=130 Celsius
	2955,	// T=131 Celsius
	3047,	// T=132 Celsius
	3141,	// T=133 Celsius
	3237,	// T=134 Celsius
	3336,	// T=135 Celsius
	3438,	// T=136 Celsius
	3542,	// T=137 Celsius
	3648,	// T=138 Celsius
	3757,	// T=139 Celsius
	3869,	// T=140 Celsius
	3984,	// T=141 Celsius
	4101,	// T=142 Celsius
	4221,	// T=143 Celsius
	4344,	// T=144 Celsius
	4470,	// T=145 Celsius
	4599,	// T=146 Celsius
	4731,	// T=147 Celsius
	4866,	// T=148 Celsius
	5005,	// T=149 Celsius
	5146,	// T=150 Celsius
	5291,	// T=151 Celsius
	5438,	// T=152 Celsius
	5590,	// T=153 Celsius
	5744,	// T=154 Celsius
	5903,	// T=155 Celsius
	6064,	// T=156 Celsius
	6230,	// T=157 Celsius
	6399,	// T=158 Celsius
	6571,	// T=159 Celsius
	6748,	// T=160 Celsius
	6928,	// T=161 Celsius
	7112,	// T=162 Celsius
	7300,	// T=163 Celsius
	7492,	// T=164 Celsius
	7688,	// T=165 Celsius
	7889,	// T=166 Celsius
	8093,	// T=167 Celsius
	8302,	// T=168 Celsius
	8515,	// T=169 Celsius
	8733,	// T=170 Celsius
	8955,	// T=171 Celsius
	9181,	// T=172 Celsius
	9412,	// T=173 Celsius
	9648,	// T=174 Celsius
	9889,	// T=175 Celsius
	10134,	// T=176 Celsius
	10384,	// T=177 Celsius
	10639,	// T=178 Celsius
	10900,	// T=179 Celsius
	11165,	// T=180 Celsius
	11435,	// T=181 Celsius
	11711,	// T=182 Celsius
	11992,	// T=183 Celsius
	12278,	// T=184 Celsius
	12570,	// T=185 Celsius
	12867,	// T=186 Celsius
	13170,	// T=187 Celsius
	13479,	// T=188 Celsius
	13793,	// T=189 Celsius
	14114,	// T=190 Celsius
	14440,	// T=191 Celsius
	14772,	// T=192 Celsius
	15110,	// T=193 Celsius
	15454,	// T=194 Celsius
	15805,	// T=195 Celsius
	16162,	// T=196 Celsius
	16525,	// T=197 Celsius
	16894,	// T=198 Celsius
	17271,	// T=199 Celsius
	17653,	// T=200 Celsius
	18043,	// T=201 Celsius
	18439,	// T=202 Celsius
	18843,	// T=203 Celsius
	19253,	// T=204 Celsius
	19670,	// T=205 Celsius
	20094,	// T=206 Celsius
	20526,	// T=207 Celsius
	20965,	// T=208 Celsius
	21411,	// T=209 Celsius
	21864,	// T=210 Celsius
	22326,	// T=211 Celsius
	22794,	// T=212 Celsius
	23271,	// T=213 Celsius
	23755,	// T=214 Celsius
	24248,	// T=215 Celsius
	24748,	// T=216 Celsius
	25256,	// T=217 Celsius
	25773,	// T=218 Celsius
	26298,	// T=219 Celsius
	26831,	// T=220 Celsius
	27372,	// T=221 Celsius
	27923,	// T=222 Celsius
	28481,	// T=223 Celsius
	29049,	// T=224 Celsius
	29625,	// T=225 Celsius
	30210,	// T=226 Celsius
	30805,	// T=227 Celsius
	31408,	// T=228 Celsius
	32020,	// T=229 Celsius
	32642,	// T=230 Celsius
	33273,	// T=231 Celsius
	33914,	// T=232 Celsius
	34564,	// T=233 Celsius
	35224,	// T=234 Celsius
	35893,	// T=235 Celsius
	36573,	// T=236 Celsius
	37262,	// T=237 Celsius
	37962,	// T=238 Celsius
	38671,	// T=239 Celsius
	39391,	// T=240 Celsius
	40121,	// T=241 Celsius
	40862,	// T=242 Celsius
	41613,	// T=243 Celsius
	42375,	// T=244 Celsius
	43148,	// T=245 Celsius
	43931,	// T=246 Celsius
	44725,	// T=247 Celsius
	45531,	// T=248 Celsius
	46347,	// T=249 Celsius
	47175,	// T=250 Celsius
	48014,	// T=251 Celsius
	48865,	// T=252 Celsius
	49727,	// T=253 Celsius
	50601,	// T=254 Celsius
	51486,	// T=255 Celsius
	52384,	// T=256 Celsius
	53293,	// T=257 Celsius
	54214,	// T=258 Celsius
	55148,	// T=259 Celsius
	56094,	// T=260 Celsius
	57052,	// T=261 Celsius
	58023,	// T=262 Celsius
	59006,	// T=263 Celsius
	60002,	// T=264 Celsius
	61011,	// T=265 Celsius
	62033,	// T=266 Celsius
	63067,	// T=267 Celsius
	64115,	// T=268 Celsius
	65176,	// T=269 Celsius
};

int h2oCelsiusToHpa(int celsius) {
	if (celsius<0) return 0;
	else if (celsius>=ELEMENTS(h2oTable)) return 0xFFFF;
	else return h2oTable[celsius];
}
