//HEADER
#include <sineTables.h>

//SLICE
const Int8 sine8To8[256] = {
	0x00,0x03,0x06,0x09,0x0c,0x10,0x13,0x16,0x19,0x1c,0x1f,0x22,0x25,0x28,0x2b,0x2e,
	0x31,0x33,0x36,0x39,0x3c,0x3f,0x41,0x44,0x47,0x49,0x4c,0x4e,0x51,0x53,0x55,0x58,
	0x5a,0x5c,0x5e,0x60,0x62,0x64,0x66,0x68,0x6a,0x6b,0x6d,0x6f,0x70,0x71,0x73,0x74,
	0x75,0x76,0x78,0x79,0x7a,0x7a,0x7b,0x7c,0x7d,0x7d,0x7e,0x7e,0x7e,0x7f,0x7f,0x7f,
	0x7f,0x7f,0x7f,0x7f,0x7e,0x7e,0x7e,0x7d,0x7d,0x7c,0x7b,0x7a,0x7a,0x79,0x78,0x76,
	0x75,0x74,0x73,0x71,0x70,0x6f,0x6d,0x6b,0x6a,0x68,0x66,0x64,0x62,0x60,0x5e,0x5c,
	0x5a,0x58,0x55,0x53,0x51,0x4e,0x4c,0x49,0x47,0x44,0x41,0x3f,0x3c,0x39,0x36,0x33,
	0x31,0x2e,0x2b,0x28,0x25,0x22,0x1f,0x1c,0x19,0x16,0x13,0x10,0x0c,0x09,0x06,0x03,
	0x00,0xfd,0xfa,0xf7,0xf4,0xf0,0xed,0xea,0xe7,0xe4,0xe1,0xde,0xdb,0xd8,0xd5,0xd2,
	0xcf,0xcd,0xca,0xc7,0xc4,0xc1,0xbf,0xbc,0xb9,0xb7,0xb4,0xb2,0xaf,0xad,0xab,0xa8,
	0xa6,0xa4,0xa2,0xa0,0x9e,0x9c,0x9a,0x98,0x96,0x95,0x93,0x91,0x90,0x8f,0x8d,0x8c,
	0x8b,0x8a,0x88,0x87,0x86,0x86,0x85,0x84,0x83,0x83,0x82,0x82,0x82,0x81,0x81,0x81,
	0x81,0x81,0x81,0x81,0x82,0x82,0x82,0x83,0x83,0x84,0x85,0x86,0x86,0x87,0x88,0x8a,
	0x8b,0x8c,0x8d,0x8f,0x90,0x91,0x93,0x95,0x96,0x98,0x9a,0x9c,0x9e,0xa0,0xa2,0xa4,
	0xa6,0xa8,0xab,0xad,0xaf,0xb2,0xb4,0xb7,0xb9,0xbc,0xbf,0xc1,0xc4,0xc7,0xca,0xcd,
	0xcf,0xd2,0xd5,0xd8,0xdb,0xde,0xe1,0xe4,0xe7,0xea,0xed,0xf0,0xf4,0xf7,0xfa,0xfd,
};

//SLICE
const Int16 sine8To16[256] = {
	0x0000,0x0324,0x0648,0x096a,0x0c8c,0x0fab,0x12c8,0x15e2,0x18f9,0x1c0b,0x1f1a,0x2223,0x2528,0x2826,0x2b1f,0x2e11,
	0x30fb,0x33df,0x36ba,0x398c,0x3c56,0x3f17,0x41ce,0x447a,0x471c,0x49b4,0x4c3f,0x4ebf,0x5133,0x539b,0x55f5,0x5842,
	0x5a82,0x5cb3,0x5ed7,0x60eb,0x62f1,0x64e8,0x66cf,0x68a6,0x6a6d,0x6c23,0x6dc9,0x6f5e,0x70e2,0x7254,0x73b5,0x7504,
	0x7641,0x776b,0x7884,0x7989,0x7a7c,0x7b5c,0x7c29,0x7ce3,0x7d89,0x7e1d,0x7e9c,0x7f09,0x7f61,0x7fa6,0x7fd8,0x7ff5,
	0x7fff,0x7ff5,0x7fd8,0x7fa6,0x7f61,0x7f09,0x7e9c,0x7e1d,0x7d89,0x7ce3,0x7c29,0x7b5c,0x7a7c,0x7989,0x7884,0x776b,
	0x7641,0x7504,0x73b5,0x7254,0x70e2,0x6f5e,0x6dc9,0x6c23,0x6a6d,0x68a6,0x66cf,0x64e8,0x62f1,0x60eb,0x5ed7,0x5cb3,
	0x5a82,0x5842,0x55f5,0x539b,0x5133,0x4ebf,0x4c3f,0x49b4,0x471c,0x447a,0x41ce,0x3f17,0x3c56,0x398c,0x36ba,0x33df,
	0x30fb,0x2e11,0x2b1f,0x2826,0x2528,0x2223,0x1f1a,0x1c0b,0x18f9,0x15e2,0x12c8,0x0fab,0x0c8c,0x096a,0x0648,0x0324,
	0x0000,0xfcdc,0xf9b8,0xf696,0xf374,0xf055,0xed38,0xea1e,0xe707,0xe3f5,0xe0e6,0xdddd,0xdad8,0xd7da,0xd4e1,0xd1ef,
	0xcf05,0xcc21,0xc946,0xc674,0xc3aa,0xc0e9,0xbe32,0xbb86,0xb8e4,0xb64c,0xb3c1,0xb141,0xaecd,0xac65,0xaa0b,0xa7be,
	0xa57e,0xa34d,0xa129,0x9f15,0x9d0f,0x9b18,0x9931,0x975a,0x9593,0x93dd,0x9237,0x90a2,0x8f1e,0x8dac,0x8c4b,0x8afc,
	0x89bf,0x8895,0x877c,0x8677,0x8584,0x84a4,0x83d7,0x831d,0x8277,0x81e3,0x8164,0x80f7,0x809f,0x805a,0x8028,0x800b,
	0x8001,0x800b,0x8028,0x805a,0x809f,0x80f7,0x8164,0x81e3,0x8277,0x831d,0x83d7,0x84a4,0x8584,0x8677,0x877c,0x8895,
	0x89bf,0x8afc,0x8c4b,0x8dac,0x8f1e,0x90a2,0x9237,0x93dd,0x9593,0x975a,0x9931,0x9b18,0x9d0f,0x9f15,0xa129,0xa34d,
	0xa57e,0xa7be,0xaa0b,0xac65,0xaecd,0xb141,0xb3c1,0xb64c,0xb8e4,0xbb86,0xbe32,0xc0e9,0xc3aa,0xc674,0xc946,0xcc21,
	0xcf05,0xd1ef,0xd4e1,0xd7da,0xdad8,0xdddd,0xe0e6,0xe3f5,0xe707,0xea1e,0xed38,0xf055,0xf374,0xf696,0xf9b8,0xfcdc,
};

//SLICE
const Int16 sine10To16[1024] = {
	0x0000,0x00c9,0x0192,0x025b,0x0324,0x03ed,0x04b6,0x057f,0x0648,0x0711,0x07d9,0x08a2,0x096a,0x0a33,0x0afb,0x0bc4,
	0x0c8c,0x0d54,0x0e1c,0x0ee3,0x0fab,0x1072,0x113a,0x1201,0x12c8,0x138f,0x1455,0x151c,0x15e2,0x16a8,0x176e,0x1833,
	0x18f9,0x19be,0x1a82,0x1b47,0x1c0b,0x1ccf,0x1d93,0x1e57,0x1f1a,0x1fdd,0x209f,0x2161,0x2223,0x22e5,0x23a6,0x2467,
	0x2528,0x25e8,0x26a8,0x2767,0x2826,0x28e5,0x29a3,0x2a61,0x2b1f,0x2bdc,0x2c99,0x2d55,0x2e11,0x2ecc,0x2f87,0x3041,
	0x30fb,0x31b5,0x326e,0x3326,0x33df,0x3496,0x354d,0x3604,0x36ba,0x376f,0x3824,0x38d9,0x398c,0x3a40,0x3af2,0x3ba5,
	0x3c56,0x3d07,0x3db8,0x3e68,0x3f17,0x3fc5,0x4073,0x4121,0x41ce,0x427a,0x4325,0x43d0,0x447a,0x4524,0x45cd,0x4675,
	0x471c,0x47c3,0x4869,0x490f,0x49b4,0x4a58,0x4afb,0x4b9d,0x4c3f,0x4ce0,0x4d81,0x4e20,0x4ebf,0x4f5d,0x4ffb,0x5097,
	0x5133,0x51ce,0x5268,0x5302,0x539b,0x5432,0x54c9,0x5560,0x55f5,0x568a,0x571d,0x57b0,0x5842,0x58d3,0x5964,0x59f3,
	0x5a82,0x5b0f,0x5b9c,0x5c28,0x5cb3,0x5d3e,0x5dc7,0x5e4f,0x5ed7,0x5f5d,0x5fe3,0x6068,0x60eb,0x616e,0x61f0,0x6271,
	0x62f1,0x6370,0x63ee,0x646c,0x64e8,0x6563,0x65dd,0x6656,0x66cf,0x6746,0x67bc,0x6832,0x68a6,0x6919,0x698b,0x69fd,
	0x6a6d,0x6adc,0x6b4a,0x6bb7,0x6c23,0x6c8e,0x6cf8,0x6d61,0x6dc9,0x6e30,0x6e96,0x6efb,0x6f5e,0x6fc1,0x7022,0x7083,
	0x70e2,0x7140,0x719d,0x71f9,0x7254,0x72ae,0x7307,0x735e,0x73b5,0x740a,0x745f,0x74b2,0x7504,0x7555,0x75a5,0x75f3,
	0x7641,0x768d,0x76d8,0x7722,0x776b,0x77b3,0x77fa,0x783f,0x7884,0x78c7,0x7909,0x794a,0x7989,0x79c8,0x7a05,0x7a41,
	0x7a7c,0x7ab6,0x7aee,0x7b26,0x7b5c,0x7b91,0x7bc5,0x7bf8,0x7c29,0x7c59,0x7c88,0x7cb6,0x7ce3,0x7d0e,0x7d39,0x7d62,
	0x7d89,0x7db0,0x7dd5,0x7dfa,0x7e1d,0x7e3e,0x7e5f,0x7e7e,0x7e9c,0x7eb9,0x7ed5,0x7eef,0x7f09,0x7f21,0x7f37,0x7f4d,
	0x7f61,0x7f74,0x7f86,0x7f97,0x7fa6,0x7fb4,0x7fc1,0x7fcd,0x7fd8,0x7fe1,0x7fe9,0x7ff0,0x7ff5,0x7ff9,0x7ffd,0x7ffe,
	0x7fff,0x7ffe,0x7ffd,0x7ff9,0x7ff5,0x7ff0,0x7fe9,0x7fe1,0x7fd8,0x7fcd,0x7fc1,0x7fb4,0x7fa6,0x7f97,0x7f86,0x7f74,
	0x7f61,0x7f4d,0x7f37,0x7f21,0x7f09,0x7eef,0x7ed5,0x7eb9,0x7e9c,0x7e7e,0x7e5f,0x7e3e,0x7e1d,0x7dfa,0x7dd5,0x7db0,
	0x7d89,0x7d62,0x7d39,0x7d0e,0x7ce3,0x7cb6,0x7c88,0x7c59,0x7c29,0x7bf8,0x7bc5,0x7b91,0x7b5c,0x7b26,0x7aee,0x7ab6,
	0x7a7c,0x7a41,0x7a05,0x79c8,0x7989,0x794a,0x7909,0x78c7,0x7884,0x783f,0x77fa,0x77b3,0x776b,0x7722,0x76d8,0x768d,
	0x7641,0x75f3,0x75a5,0x7555,0x7504,0x74b2,0x745f,0x740a,0x73b5,0x735e,0x7307,0x72ae,0x7254,0x71f9,0x719d,0x7140,
	0x70e2,0x7083,0x7022,0x6fc1,0x6f5e,0x6efb,0x6e96,0x6e30,0x6dc9,0x6d61,0x6cf8,0x6c8e,0x6c23,0x6bb7,0x6b4a,0x6adc,
	0x6a6d,0x69fd,0x698b,0x6919,0x68a6,0x6832,0x67bc,0x6746,0x66cf,0x6656,0x65dd,0x6563,0x64e8,0x646c,0x63ee,0x6370,
	0x62f1,0x6271,0x61f0,0x616e,0x60eb,0x6068,0x5fe3,0x5f5d,0x5ed7,0x5e4f,0x5dc7,0x5d3e,0x5cb3,0x5c28,0x5b9c,0x5b0f,
	0x5a82,0x59f3,0x5964,0x58d3,0x5842,0x57b0,0x571d,0x568a,0x55f5,0x5560,0x54c9,0x5432,0x539b,0x5302,0x5268,0x51ce,
	0x5133,0x5097,0x4ffb,0x4f5d,0x4ebf,0x4e20,0x4d81,0x4ce0,0x4c3f,0x4b9d,0x4afb,0x4a58,0x49b4,0x490f,0x4869,0x47c3,
	0x471c,0x4675,0x45cd,0x4524,0x447a,0x43d0,0x4325,0x427a,0x41ce,0x4121,0x4073,0x3fc5,0x3f17,0x3e68,0x3db8,0x3d07,
	0x3c56,0x3ba5,0x3af2,0x3a40,0x398c,0x38d9,0x3824,0x376f,0x36ba,0x3604,0x354d,0x3496,0x33df,0x3326,0x326e,0x31b5,
	0x30fb,0x3041,0x2f87,0x2ecc,0x2e11,0x2d55,0x2c99,0x2bdc,0x2b1f,0x2a61,0x29a3,0x28e5,0x2826,0x2767,0x26a8,0x25e8,
	0x2528,0x2467,0x23a6,0x22e5,0x2223,0x2161,0x209f,0x1fdd,0x1f1a,0x1e57,0x1d93,0x1ccf,0x1c0b,0x1b47,0x1a82,0x19be,
	0x18f9,0x1833,0x176e,0x16a8,0x15e2,0x151c,0x1455,0x138f,0x12c8,0x1201,0x113a,0x1072,0x0fab,0x0ee3,0x0e1c,0x0d54,
	0x0c8c,0x0bc4,0x0afb,0x0a33,0x096a,0x08a2,0x07d9,0x0711,0x0648,0x057f,0x04b6,0x03ed,0x0324,0x025b,0x0192,0x00c9,
	0x0000,0xff37,0xfe6e,0xfda5,0xfcdc,0xfc13,0xfb4a,0xfa81,0xf9b8,0xf8ef,0xf827,0xf75e,0xf696,0xf5cd,0xf505,0xf43c,
	0xf374,0xf2ac,0xf1e4,0xf11d,0xf055,0xef8e,0xeec6,0xedff,0xed38,0xec71,0xebab,0xeae4,0xea1e,0xe958,0xe892,0xe7cd,
	0xe707,0xe642,0xe57e,0xe4b9,0xe3f5,0xe331,0xe26d,0xe1a9,0xe0e6,0xe023,0xdf61,0xde9f,0xdddd,0xdd1b,0xdc5a,0xdb99,
	0xdad8,0xda18,0xd958,0xd899,0xd7da,0xd71b,0xd65d,0xd59f,0xd4e1,0xd424,0xd367,0xd2ab,0xd1ef,0xd134,0xd079,0xcfbf,
	0xcf05,0xce4b,0xcd92,0xccda,0xcc21,0xcb6a,0xcab3,0xc9fc,0xc946,0xc891,0xc7dc,0xc727,0xc674,0xc5c0,0xc50e,0xc45b,
	0xc3aa,0xc2f9,0xc248,0xc198,0xc0e9,0xc03b,0xbf8d,0xbedf,0xbe32,0xbd86,0xbcdb,0xbc30,0xbb86,0xbadc,0xba33,0xb98b,
	0xb8e4,0xb83d,0xb797,0xb6f1,0xb64c,0xb5a8,0xb505,0xb463,0xb3c1,0xb320,0xb27f,0xb1e0,0xb141,0xb0a3,0xb005,0xaf69,
	0xaecd,0xae32,0xad98,0xacfe,0xac65,0xabce,0xab37,0xaaa0,0xaa0b,0xa976,0xa8e3,0xa850,0xa7be,0xa72d,0xa69c,0xa60d,
	0xa57e,0xa4f1,0xa464,0xa3d8,0xa34d,0xa2c2,0xa239,0xa1b1,0xa129,0xa0a3,0xa01d,0x9f98,0x9f15,0x9e92,0x9e10,0x9d8f,
	0x9d0f,0x9c90,0x9c12,0x9b94,0x9b18,0x9a9d,0x9a23,0x99aa,0x9931,0x98ba,0x9844,0x97ce,0x975a,0x96e7,0x9675,0x9603,
	0x9593,0x9524,0x94b6,0x9449,0x93dd,0x9372,0x9308,0x929f,0x9237,0x91d0,0x916a,0x9105,0x90a2,0x903f,0x8fde,0x8f7d,
	0x8f1e,0x8ec0,0x8e63,0x8e07,0x8dac,0x8d52,0x8cf9,0x8ca2,0x8c4b,0x8bf6,0x8ba1,0x8b4e,0x8afc,0x8aab,0x8a5b,0x8a0d,
	0x89bf,0x8973,0x8928,0x88de,0x8895,0x884d,0x8806,0x87c1,0x877c,0x8739,0x86f7,0x86b6,0x8677,0x8638,0x85fb,0x85bf,
	0x8584,0x854a,0x8512,0x84da,0x84a4,0x846f,0x843b,0x8408,0x83d7,0x83a7,0x8378,0x834a,0x831d,0x82f2,0x82c7,0x829e,
	0x8277,0x8250,0x822b,0x8206,0x81e3,0x81c2,0x81a1,0x8182,0x8164,0x8147,0x812b,0x8111,0x80f7,0x80df,0x80c9,0x80b3,
	0x809f,0x808c,0x807a,0x8069,0x805a,0x804c,0x803f,0x8033,0x8028,0x801f,0x8017,0x8010,0x800b,0x8007,0x8003,0x8002,
	0x8001,0x8002,0x8003,0x8007,0x800b,0x8010,0x8017,0x801f,0x8028,0x8033,0x803f,0x804c,0x805a,0x8069,0x807a,0x808c,
	0x809f,0x80b3,0x80c9,0x80df,0x80f7,0x8111,0x812b,0x8147,0x8164,0x8182,0x81a1,0x81c2,0x81e3,0x8206,0x822b,0x8250,
	0x8277,0x829e,0x82c7,0x82f2,0x831d,0x834a,0x8378,0x83a7,0x83d7,0x8408,0x843b,0x846f,0x84a4,0x84da,0x8512,0x854a,
	0x8584,0x85bf,0x85fb,0x8638,0x8677,0x86b6,0x86f7,0x8739,0x877c,0x87c1,0x8806,0x884d,0x8895,0x88de,0x8928,0x8973,
	0x89bf,0x8a0d,0x8a5b,0x8aab,0x8afc,0x8b4e,0x8ba1,0x8bf6,0x8c4b,0x8ca2,0x8cf9,0x8d52,0x8dac,0x8e07,0x8e63,0x8ec0,
	0x8f1e,0x8f7d,0x8fde,0x903f,0x90a2,0x9105,0x916a,0x91d0,0x9237,0x929f,0x9308,0x9372,0x93dd,0x9449,0x94b6,0x9524,
	0x9593,0x9603,0x9675,0x96e7,0x975a,0x97ce,0x9844,0x98ba,0x9931,0x99aa,0x9a23,0x9a9d,0x9b18,0x9b94,0x9c12,0x9c90,
	0x9d0f,0x9d8f,0x9e10,0x9e92,0x9f15,0x9f98,0xa01d,0xa0a3,0xa129,0xa1b1,0xa239,0xa2c2,0xa34d,0xa3d8,0xa464,0xa4f1,
	0xa57e,0xa60d,0xa69c,0xa72d,0xa7be,0xa850,0xa8e3,0xa976,0xaa0b,0xaaa0,0xab37,0xabce,0xac65,0xacfe,0xad98,0xae32,
	0xaecd,0xaf69,0xb005,0xb0a3,0xb141,0xb1e0,0xb27f,0xb320,0xb3c1,0xb463,0xb505,0xb5a8,0xb64c,0xb6f1,0xb797,0xb83d,
	0xb8e4,0xb98b,0xba33,0xbadc,0xbb86,0xbc30,0xbcdb,0xbd86,0xbe32,0xbedf,0xbf8d,0xc03b,0xc0e9,0xc198,0xc248,0xc2f9,
	0xc3aa,0xc45b,0xc50e,0xc5c0,0xc674,0xc727,0xc7dc,0xc891,0xc946,0xc9fc,0xcab3,0xcb6a,0xcc21,0xccda,0xcd92,0xce4b,
	0xcf05,0xcfbf,0xd079,0xd134,0xd1ef,0xd2ab,0xd367,0xd424,0xd4e1,0xd59f,0xd65d,0xd71b,0xd7da,0xd899,0xd958,0xda18,
	0xdad8,0xdb99,0xdc5a,0xdd1b,0xdddd,0xde9f,0xdf61,0xe023,0xe0e6,0xe1a9,0xe26d,0xe331,0xe3f5,0xe4b9,0xe57e,0xe642,
	0xe707,0xe7cd,0xe892,0xe958,0xea1e,0xeae4,0xebab,0xec71,0xed38,0xedff,0xeec6,0xef8e,0xf055,0xf11d,0xf1e4,0xf2ac,
	0xf374,0xf43c,0xf505,0xf5cd,0xf696,0xf75e,0xf827,0xf8ef,0xf9b8,0xfa81,0xfb4a,0xfc13,0xfcdc,0xfda5,0xfe6e,0xff37,
};

//SLICE
const Int16 sine12To16[4096] = {
	0x0000,0x0032,0x0065,0x0097,0x00c9,0x00fb,0x012e,0x0160,0x0192,0x01c4,0x01f7,0x0229,0x025b,0x028d,0x02c0,0x02f2,
	0x0324,0x0356,0x0389,0x03bb,0x03ed,0x041f,0x0452,0x0484,0x04b6,0x04e8,0x051b,0x054d,0x057f,0x05b1,0x05e3,0x0616,
	0x0648,0x067a,0x06ac,0x06de,0x0711,0x0743,0x0775,0x07a7,0x07d9,0x080b,0x083e,0x0870,0x08a2,0x08d4,0x0906,0x0938,
	0x096a,0x099d,0x09cf,0x0a01,0x0a33,0x0a65,0x0a97,0x0ac9,0x0afb,0x0b2d,0x0b5f,0x0b92,0x0bc4,0x0bf6,0x0c28,0x0c5a,
	0x0c8c,0x0cbe,0x0cf0,0x0d22,0x0d54,0x0d86,0x0db8,0x0dea,0x0e1c,0x0e4e,0x0e80,0x0eb1,0x0ee3,0x0f15,0x0f47,0x0f79,
	0x0fab,0x0fdd,0x100f,0x1041,0x1072,0x10a4,0x10d6,0x1108,0x113a,0x116c,0x119d,0x11cf,0x1201,0x1233,0x1264,0x1296,
	0x12c8,0x12fa,0x132b,0x135d,0x138f,0x13c0,0x13f2,0x1424,0x1455,0x1487,0x14b9,0x14ea,0x151c,0x154d,0x157f,0x15b0,
	0x15e2,0x1613,0x1645,0x1676,0x16a8,0x16d9,0x170b,0x173c,0x176e,0x179f,0x17d0,0x1802,0x1833,0x1865,0x1896,0x18c7,
	0x18f9,0x192a,0x195b,0x198c,0x19be,0x19ef,0x1a20,0x1a51,0x1a82,0x1ab4,0x1ae5,0x1b16,0x1b47,0x1b78,0x1ba9,0x1bda,
	0x1c0b,0x1c3c,0x1c6d,0x1c9e,0x1ccf,0x1d00,0x1d31,0x1d62,0x1d93,0x1dc4,0x1df5,0x1e26,0x1e57,0x1e87,0x1eb8,0x1ee9,
	0x1f1a,0x1f4a,0x1f7b,0x1fac,0x1fdd,0x200d,0x203e,0x206f,0x209f,0x20d0,0x2100,0x2131,0x2161,0x2192,0x21c2,0x21f3,
	0x2223,0x2254,0x2284,0x22b5,0x22e5,0x2315,0x2346,0x2376,0x23a6,0x23d7,0x2407,0x2437,0x2467,0x2497,0x24c8,0x24f8,
	0x2528,0x2558,0x2588,0x25b8,0x25e8,0x2618,0x2648,0x2678,0x26a8,0x26d8,0x2708,0x2737,0x2767,0x2797,0x27c7,0x27f7,
	0x2826,0x2856,0x2886,0x28b5,0x28e5,0x2915,0x2944,0x2974,0x29a3,0x29d3,0x2a02,0x2a32,0x2a61,0x2a91,0x2ac0,0x2af0,
	0x2b1f,0x2b4e,0x2b7d,0x2bad,0x2bdc,0x2c0b,0x2c3a,0x2c6a,0x2c99,0x2cc8,0x2cf7,0x2d26,0x2d55,0x2d84,0x2db3,0x2de2,
	0x2e11,0x2e40,0x2e6e,0x2e9d,0x2ecc,0x2efb,0x2f2a,0x2f58,0x2f87,0x2fb6,0x2fe4,0x3013,0x3041,0x3070,0x309e,0x30cd,
	0x30fb,0x312a,0x3158,0x3187,0x31b5,0x31e3,0x3211,0x3240,0x326e,0x329c,0x32ca,0x32f8,0x3326,0x3355,0x3383,0x33b1,
	0x33df,0x340c,0x343a,0x3468,0x3496,0x34c4,0x34f2,0x351f,0x354d,0x357b,0x35a8,0x35d6,0x3604,0x3631,0x365f,0x368c,
	0x36ba,0x36e7,0x3715,0x3742,0x376f,0x379c,0x37ca,0x37f7,0x3824,0x3851,0x387e,0x38ab,0x38d9,0x3906,0x3933,0x3960,
	0x398c,0x39b9,0x39e6,0x3a13,0x3a40,0x3a6c,0x3a99,0x3ac6,0x3af2,0x3b1f,0x3b4c,0x3b78,0x3ba5,0x3bd1,0x3bfe,0x3c2a,
	0x3c56,0x3c83,0x3caf,0x3cdb,0x3d07,0x3d33,0x3d60,0x3d8c,0x3db8,0x3de4,0x3e10,0x3e3c,0x3e68,0x3e93,0x3ebf,0x3eeb,
	0x3f17,0x3f43,0x3f6e,0x3f9a,0x3fc5,0x3ff1,0x401d,0x4048,0x4073,0x409f,0x40ca,0x40f6,0x4121,0x414c,0x4177,0x41a2,
	0x41ce,0x41f9,0x4224,0x424f,0x427a,0x42a5,0x42d0,0x42fa,0x4325,0x4350,0x437b,0x43a5,0x43d0,0x43fb,0x4425,0x4450,
	0x447a,0x44a5,0x44cf,0x44f9,0x4524,0x454e,0x4578,0x45a3,0x45cd,0x45f7,0x4621,0x464b,0x4675,0x469f,0x46c9,0x46f3,
	0x471c,0x4746,0x4770,0x479a,0x47c3,0x47ed,0x4816,0x4840,0x4869,0x4893,0x48bc,0x48e5,0x490f,0x4938,0x4961,0x498a,
	0x49b4,0x49dd,0x4a06,0x4a2f,0x4a58,0x4a80,0x4aa9,0x4ad2,0x4afb,0x4b24,0x4b4c,0x4b75,0x4b9d,0x4bc6,0x4bee,0x4c17,
	0x4c3f,0x4c68,0x4c90,0x4cb8,0x4ce0,0x4d09,0x4d31,0x4d59,0x4d81,0x4da9,0x4dd1,0x4df9,0x4e20,0x4e48,0x4e70,0x4e98,
	0x4ebf,0x4ee7,0x4f0e,0x4f36,0x4f5d,0x4f85,0x4fac,0x4fd4,0x4ffb,0x5022,0x5049,0x5070,0x5097,0x50be,0x50e5,0x510c,
	0x5133,0x515a,0x5181,0x51a8,0x51ce,0x51f5,0x521b,0x5242,0x5268,0x528f,0x52b5,0x52dc,0x5302,0x5328,0x534e,0x5374,
	0x539b,0x53c1,0x53e7,0x540c,0x5432,0x5458,0x547e,0x54a4,0x54c9,0x54ef,0x5515,0x553a,0x5560,0x5585,0x55aa,0x55d0,
	0x55f5,0x561a,0x563f,0x5664,0x568a,0x56af,0x56d3,0x56f8,0x571d,0x5742,0x5767,0x578b,0x57b0,0x57d5,0x57f9,0x581e,
	0x5842,0x5867,0x588b,0x58af,0x58d3,0x58f8,0x591c,0x5940,0x5964,0x5988,0x59ac,0x59cf,0x59f3,0x5a17,0x5a3b,0x5a5e,
	0x5a82,0x5aa5,0x5ac9,0x5aec,0x5b0f,0x5b33,0x5b56,0x5b79,0x5b9c,0x5bbf,0x5be2,0x5c05,0x5c28,0x5c4b,0x5c6e,0x5c91,
	0x5cb3,0x5cd6,0x5cf9,0x5d1b,0x5d3e,0x5d60,0x5d82,0x5da5,0x5dc7,0x5de9,0x5e0b,0x5e2d,0x5e4f,0x5e71,0x5e93,0x5eb5,
	0x5ed7,0x5ef8,0x5f1a,0x5f3c,0x5f5d,0x5f7f,0x5fa0,0x5fc2,0x5fe3,0x6004,0x6025,0x6047,0x6068,0x6089,0x60aa,0x60cb,
	0x60eb,0x610c,0x612d,0x614e,0x616e,0x618f,0x61af,0x61d0,0x61f0,0x6211,0x6231,0x6251,0x6271,0x6291,0x62b1,0x62d1,
	0x62f1,0x6311,0x6331,0x6351,0x6370,0x6390,0x63af,0x63cf,0x63ee,0x640e,0x642d,0x644c,0x646c,0x648b,0x64aa,0x64c9,
	0x64e8,0x6507,0x6525,0x6544,0x6563,0x6582,0x65a0,0x65bf,0x65dd,0x65fc,0x661a,0x6638,0x6656,0x6675,0x6693,0x66b1,
	0x66cf,0x66ed,0x670a,0x6728,0x6746,0x6764,0x6781,0x679f,0x67bc,0x67da,0x67f7,0x6814,0x6832,0x684f,0x686c,0x6889,
	0x68a6,0x68c3,0x68e0,0x68fc,0x6919,0x6936,0x6952,0x696f,0x698b,0x69a8,0x69c4,0x69e0,0x69fd,0x6a19,0x6a35,0x6a51,
	0x6a6d,0x6a89,0x6aa4,0x6ac0,0x6adc,0x6af8,0x6b13,0x6b2f,0x6b4a,0x6b65,0x6b81,0x6b9c,0x6bb7,0x6bd2,0x6bed,0x6c08,
	0x6c23,0x6c3e,0x6c59,0x6c74,0x6c8e,0x6ca9,0x6cc3,0x6cde,0x6cf8,0x6d13,0x6d2d,0x6d47,0x6d61,0x6d7b,0x6d95,0x6daf,
	0x6dc9,0x6de3,0x6dfd,0x6e16,0x6e30,0x6e4a,0x6e63,0x6e7c,0x6e96,0x6eaf,0x6ec8,0x6ee1,0x6efb,0x6f14,0x6f2c,0x6f45,
	0x6f5e,0x6f77,0x6f90,0x6fa8,0x6fc1,0x6fd9,0x6ff2,0x700a,0x7022,0x703a,0x7053,0x706b,0x7083,0x709b,0x70b2,0x70ca,
	0x70e2,0x70fa,0x7111,0x7129,0x7140,0x7158,0x716f,0x7186,0x719d,0x71b4,0x71cb,0x71e2,0x71f9,0x7210,0x7227,0x723e,
	0x7254,0x726b,0x7281,0x7298,0x72ae,0x72c4,0x72db,0x72f1,0x7307,0x731d,0x7333,0x7349,0x735e,0x7374,0x738a,0x739f,
	0x73b5,0x73ca,0x73e0,0x73f5,0x740a,0x7420,0x7435,0x744a,0x745f,0x7474,0x7488,0x749d,0x74b2,0x74c6,0x74db,0x74f0,
	0x7504,0x7518,0x752d,0x7541,0x7555,0x7569,0x757d,0x7591,0x75a5,0x75b8,0x75cc,0x75e0,0x75f3,0x7607,0x761a,0x762d,
	0x7641,0x7654,0x7667,0x767a,0x768d,0x76a0,0x76b3,0x76c6,0x76d8,0x76eb,0x76fe,0x7710,0x7722,0x7735,0x7747,0x7759,
	0x776b,0x777d,0x778f,0x77a1,0x77b3,0x77c5,0x77d7,0x77e8,0x77fa,0x780b,0x781d,0x782e,0x783f,0x7850,0x7862,0x7873,
	0x7884,0x7894,0x78a5,0x78b6,0x78c7,0x78d7,0x78e8,0x78f8,0x7909,0x7919,0x7929,0x7939,0x794a,0x795a,0x796a,0x7979,
	0x7989,0x7999,0x79a9,0x79b8,0x79c8,0x79d7,0x79e6,0x79f6,0x7a05,0x7a14,0x7a23,0x7a32,0x7a41,0x7a50,0x7a5f,0x7a6d,
	0x7a7c,0x7a8b,0x7a99,0x7aa8,0x7ab6,0x7ac4,0x7ad2,0x7ae0,0x7aee,0x7afc,0x7b0a,0x7b18,0x7b26,0x7b33,0x7b41,0x7b4f,
	0x7b5c,0x7b69,0x7b77,0x7b84,0x7b91,0x7b9e,0x7bab,0x7bb8,0x7bc5,0x7bd2,0x7bde,0x7beb,0x7bf8,0x7c04,0x7c10,0x7c1d,
	0x7c29,0x7c35,0x7c41,0x7c4d,0x7c59,0x7c65,0x7c71,0x7c7d,0x7c88,0x7c94,0x7c9f,0x7cab,0x7cb6,0x7cc1,0x7ccd,0x7cd8,
	0x7ce3,0x7cee,0x7cf9,0x7d04,0x7d0e,0x7d19,0x7d24,0x7d2e,0x7d39,0x7d43,0x7d4d,0x7d57,0x7d62,0x7d6c,0x7d76,0x7d80,
	0x7d89,0x7d93,0x7d9d,0x7da6,0x7db0,0x7db9,0x7dc3,0x7dcc,0x7dd5,0x7ddf,0x7de8,0x7df1,0x7dfa,0x7e02,0x7e0b,0x7e14,
	0x7e1d,0x7e25,0x7e2e,0x7e36,0x7e3e,0x7e47,0x7e4f,0x7e57,0x7e5f,0x7e67,0x7e6f,0x7e77,0x7e7e,0x7e86,0x7e8d,0x7e95,
	0x7e9c,0x7ea4,0x7eab,0x7eb2,0x7eb9,0x7ec0,0x7ec7,0x7ece,0x7ed5,0x7edc,0x7ee2,0x7ee9,0x7eef,0x7ef6,0x7efc,0x7f02,
	0x7f09,0x7f0f,0x7f15,0x7f1b,0x7f21,0x7f26,0x7f2c,0x7f32,0x7f37,0x7f3d,0x7f42,0x7f48,0x7f4d,0x7f52,0x7f57,0x7f5c,
	0x7f61,0x7f66,0x7f6b,0x7f70,0x7f74,0x7f79,0x7f7d,0x7f82,0x7f86,0x7f8a,0x7f8f,0x7f93,0x7f97,0x7f9b,0x7f9f,0x7fa2,
	0x7fa6,0x7faa,0x7fad,0x7fb1,0x7fb4,0x7fb8,0x7fbb,0x7fbe,0x7fc1,0x7fc4,0x7fc7,0x7fca,0x7fcd,0x7fd0,0x7fd2,0x7fd5,
	0x7fd8,0x7fda,0x7fdc,0x7fdf,0x7fe1,0x7fe3,0x7fe5,0x7fe7,0x7fe9,0x7feb,0x7fec,0x7fee,0x7ff0,0x7ff1,0x7ff3,0x7ff4,
	0x7ff5,0x7ff6,0x7ff7,0x7ff8,0x7ff9,0x7ffa,0x7ffb,0x7ffc,0x7ffd,0x7ffd,0x7ffe,0x7ffe,0x7ffe,0x7fff,0x7fff,0x7fff,
	0x7fff,0x7fff,0x7fff,0x7fff,0x7ffe,0x7ffe,0x7ffe,0x7ffd,0x7ffd,0x7ffc,0x7ffb,0x7ffa,0x7ff9,0x7ff8,0x7ff7,0x7ff6,
	0x7ff5,0x7ff4,0x7ff3,0x7ff1,0x7ff0,0x7fee,0x7fec,0x7feb,0x7fe9,0x7fe7,0x7fe5,0x7fe3,0x7fe1,0x7fdf,0x7fdc,0x7fda,
	0x7fd8,0x7fd5,0x7fd2,0x7fd0,0x7fcd,0x7fca,0x7fc7,0x7fc4,0x7fc1,0x7fbe,0x7fbb,0x7fb8,0x7fb4,0x7fb1,0x7fad,0x7faa,
	0x7fa6,0x7fa2,0x7f9f,0x7f9b,0x7f97,0x7f93,0x7f8f,0x7f8a,0x7f86,0x7f82,0x7f7d,0x7f79,0x7f74,0x7f70,0x7f6b,0x7f66,
	0x7f61,0x7f5c,0x7f57,0x7f52,0x7f4d,0x7f48,0x7f42,0x7f3d,0x7f37,0x7f32,0x7f2c,0x7f26,0x7f21,0x7f1b,0x7f15,0x7f0f,
	0x7f09,0x7f02,0x7efc,0x7ef6,0x7eef,0x7ee9,0x7ee2,0x7edc,0x7ed5,0x7ece,0x7ec7,0x7ec0,0x7eb9,0x7eb2,0x7eab,0x7ea4,
	0x7e9c,0x7e95,0x7e8d,0x7e86,0x7e7e,0x7e77,0x7e6f,0x7e67,0x7e5f,0x7e57,0x7e4f,0x7e47,0x7e3e,0x7e36,0x7e2e,0x7e25,
	0x7e1d,0x7e14,0x7e0b,0x7e02,0x7dfa,0x7df1,0x7de8,0x7ddf,0x7dd5,0x7dcc,0x7dc3,0x7db9,0x7db0,0x7da6,0x7d9d,0x7d93,
	0x7d89,0x7d80,0x7d76,0x7d6c,0x7d62,0x7d57,0x7d4d,0x7d43,0x7d39,0x7d2e,0x7d24,0x7d19,0x7d0e,0x7d04,0x7cf9,0x7cee,
	0x7ce3,0x7cd8,0x7ccd,0x7cc1,0x7cb6,0x7cab,0x7c9f,0x7c94,0x7c88,0x7c7d,0x7c71,0x7c65,0x7c59,0x7c4d,0x7c41,0x7c35,
	0x7c29,0x7c1d,0x7c10,0x7c04,0x7bf8,0x7beb,0x7bde,0x7bd2,0x7bc5,0x7bb8,0x7bab,0x7b9e,0x7b91,0x7b84,0x7b77,0x7b69,
	0x7b5c,0x7b4f,0x7b41,0x7b33,0x7b26,0x7b18,0x7b0a,0x7afc,0x7aee,0x7ae0,0x7ad2,0x7ac4,0x7ab6,0x7aa8,0x7a99,0x7a8b,
	0x7a7c,0x7a6d,0x7a5f,0x7a50,0x7a41,0x7a32,0x7a23,0x7a14,0x7a05,0x79f6,0x79e6,0x79d7,0x79c8,0x79b8,0x79a9,0x7999,
	0x7989,0x7979,0x796a,0x795a,0x794a,0x7939,0x7929,0x7919,0x7909,0x78f8,0x78e8,0x78d7,0x78c7,0x78b6,0x78a5,0x7894,
	0x7884,0x7873,0x7862,0x7850,0x783f,0x782e,0x781d,0x780b,0x77fa,0x77e8,0x77d7,0x77c5,0x77b3,0x77a1,0x778f,0x777d,
	0x776b,0x7759,0x7747,0x7735,0x7722,0x7710,0x76fe,0x76eb,0x76d8,0x76c6,0x76b3,0x76a0,0x768d,0x767a,0x7667,0x7654,
	0x7641,0x762d,0x761a,0x7607,0x75f3,0x75e0,0x75cc,0x75b8,0x75a5,0x7591,0x757d,0x7569,0x7555,0x7541,0x752d,0x7518,
	0x7504,0x74f0,0x74db,0x74c6,0x74b2,0x749d,0x7488,0x7474,0x745f,0x744a,0x7435,0x7420,0x740a,0x73f5,0x73e0,0x73ca,
	0x73b5,0x739f,0x738a,0x7374,0x735e,0x7349,0x7333,0x731d,0x7307,0x72f1,0x72db,0x72c4,0x72ae,0x7298,0x7281,0x726b,
	0x7254,0x723e,0x7227,0x7210,0x71f9,0x71e2,0x71cb,0x71b4,0x719d,0x7186,0x716f,0x7158,0x7140,0x7129,0x7111,0x70fa,
	0x70e2,0x70ca,0x70b2,0x709b,0x7083,0x706b,0x7053,0x703a,0x7022,0x700a,0x6ff2,0x6fd9,0x6fc1,0x6fa8,0x6f90,0x6f77,
	0x6f5e,0x6f45,0x6f2c,0x6f14,0x6efb,0x6ee1,0x6ec8,0x6eaf,0x6e96,0x6e7c,0x6e63,0x6e4a,0x6e30,0x6e16,0x6dfd,0x6de3,
	0x6dc9,0x6daf,0x6d95,0x6d7b,0x6d61,0x6d47,0x6d2d,0x6d13,0x6cf8,0x6cde,0x6cc3,0x6ca9,0x6c8e,0x6c74,0x6c59,0x6c3e,
	0x6c23,0x6c08,0x6bed,0x6bd2,0x6bb7,0x6b9c,0x6b81,0x6b65,0x6b4a,0x6b2f,0x6b13,0x6af8,0x6adc,0x6ac0,0x6aa4,0x6a89,
	0x6a6d,0x6a51,0x6a35,0x6a19,0x69fd,0x69e0,0x69c4,0x69a8,0x698b,0x696f,0x6952,0x6936,0x6919,0x68fc,0x68e0,0x68c3,
	0x68a6,0x6889,0x686c,0x684f,0x6832,0x6814,0x67f7,0x67da,0x67bc,0x679f,0x6781,0x6764,0x6746,0x6728,0x670a,0x66ed,
	0x66cf,0x66b1,0x6693,0x6675,0x6656,0x6638,0x661a,0x65fc,0x65dd,0x65bf,0x65a0,0x6582,0x6563,0x6544,0x6525,0x6507,
	0x64e8,0x64c9,0x64aa,0x648b,0x646c,0x644c,0x642d,0x640e,0x63ee,0x63cf,0x63af,0x6390,0x6370,0x6351,0x6331,0x6311,
	0x62f1,0x62d1,0x62b1,0x6291,0x6271,0x6251,0x6231,0x6211,0x61f0,0x61d0,0x61af,0x618f,0x616e,0x614e,0x612d,0x610c,
	0x60eb,0x60cb,0x60aa,0x6089,0x6068,0x6047,0x6025,0x6004,0x5fe3,0x5fc2,0x5fa0,0x5f7f,0x5f5d,0x5f3c,0x5f1a,0x5ef8,
	0x5ed7,0x5eb5,0x5e93,0x5e71,0x5e4f,0x5e2d,0x5e0b,0x5de9,0x5dc7,0x5da5,0x5d82,0x5d60,0x5d3e,0x5d1b,0x5cf9,0x5cd6,
	0x5cb3,0x5c91,0x5c6e,0x5c4b,0x5c28,0x5c05,0x5be2,0x5bbf,0x5b9c,0x5b79,0x5b56,0x5b33,0x5b0f,0x5aec,0x5ac9,0x5aa5,
	0x5a82,0x5a5e,0x5a3b,0x5a17,0x59f3,0x59cf,0x59ac,0x5988,0x5964,0x5940,0x591c,0x58f8,0x58d3,0x58af,0x588b,0x5867,
	0x5842,0x581e,0x57f9,0x57d5,0x57b0,0x578b,0x5767,0x5742,0x571d,0x56f8,0x56d3,0x56af,0x568a,0x5664,0x563f,0x561a,
	0x55f5,0x55d0,0x55aa,0x5585,0x5560,0x553a,0x5515,0x54ef,0x54c9,0x54a4,0x547e,0x5458,0x5432,0x540c,0x53e7,0x53c1,
	0x539b,0x5374,0x534e,0x5328,0x5302,0x52dc,0x52b5,0x528f,0x5268,0x5242,0x521b,0x51f5,0x51ce,0x51a8,0x5181,0x515a,
	0x5133,0x510c,0x50e5,0x50be,0x5097,0x5070,0x5049,0x5022,0x4ffb,0x4fd4,0x4fac,0x4f85,0x4f5d,0x4f36,0x4f0e,0x4ee7,
	0x4ebf,0x4e98,0x4e70,0x4e48,0x4e20,0x4df9,0x4dd1,0x4da9,0x4d81,0x4d59,0x4d31,0x4d09,0x4ce0,0x4cb8,0x4c90,0x4c68,
	0x4c3f,0x4c17,0x4bee,0x4bc6,0x4b9d,0x4b75,0x4b4c,0x4b24,0x4afb,0x4ad2,0x4aa9,0x4a80,0x4a58,0x4a2f,0x4a06,0x49dd,
	0x49b4,0x498a,0x4961,0x4938,0x490f,0x48e5,0x48bc,0x4893,0x4869,0x4840,0x4816,0x47ed,0x47c3,0x479a,0x4770,0x4746,
	0x471c,0x46f3,0x46c9,0x469f,0x4675,0x464b,0x4621,0x45f7,0x45cd,0x45a3,0x4578,0x454e,0x4524,0x44f9,0x44cf,0x44a5,
	0x447a,0x4450,0x4425,0x43fb,0x43d0,0x43a5,0x437b,0x4350,0x4325,0x42fa,0x42d0,0x42a5,0x427a,0x424f,0x4224,0x41f9,
	0x41ce,0x41a2,0x4177,0x414c,0x4121,0x40f6,0x40ca,0x409f,0x4073,0x4048,0x401d,0x3ff1,0x3fc5,0x3f9a,0x3f6e,0x3f43,
	0x3f17,0x3eeb,0x3ebf,0x3e93,0x3e68,0x3e3c,0x3e10,0x3de4,0x3db8,0x3d8c,0x3d60,0x3d33,0x3d07,0x3cdb,0x3caf,0x3c83,
	0x3c56,0x3c2a,0x3bfe,0x3bd1,0x3ba5,0x3b78,0x3b4c,0x3b1f,0x3af2,0x3ac6,0x3a99,0x3a6c,0x3a40,0x3a13,0x39e6,0x39b9,
	0x398c,0x3960,0x3933,0x3906,0x38d9,0x38ab,0x387e,0x3851,0x3824,0x37f7,0x37ca,0x379c,0x376f,0x3742,0x3715,0x36e7,
	0x36ba,0x368c,0x365f,0x3631,0x3604,0x35d6,0x35a8,0x357b,0x354d,0x351f,0x34f2,0x34c4,0x3496,0x3468,0x343a,0x340c,
	0x33df,0x33b1,0x3383,0x3355,0x3326,0x32f8,0x32ca,0x329c,0x326e,0x3240,0x3211,0x31e3,0x31b5,0x3187,0x3158,0x312a,
	0x30fb,0x30cd,0x309e,0x3070,0x3041,0x3013,0x2fe4,0x2fb6,0x2f87,0x2f58,0x2f2a,0x2efb,0x2ecc,0x2e9d,0x2e6e,0x2e40,
	0x2e11,0x2de2,0x2db3,0x2d84,0x2d55,0x2d26,0x2cf7,0x2cc8,0x2c99,0x2c6a,0x2c3a,0x2c0b,0x2bdc,0x2bad,0x2b7d,0x2b4e,
	0x2b1f,0x2af0,0x2ac0,0x2a91,0x2a61,0x2a32,0x2a02,0x29d3,0x29a3,0x2974,0x2944,0x2915,0x28e5,0x28b5,0x2886,0x2856,
	0x2826,0x27f7,0x27c7,0x2797,0x2767,0x2737,0x2708,0x26d8,0x26a8,0x2678,0x2648,0x2618,0x25e8,0x25b8,0x2588,0x2558,
	0x2528,0x24f8,0x24c8,0x2497,0x2467,0x2437,0x2407,0x23d7,0x23a6,0x2376,0x2346,0x2315,0x22e5,0x22b5,0x2284,0x2254,
	0x2223,0x21f3,0x21c2,0x2192,0x2161,0x2131,0x2100,0x20d0,0x209f,0x206f,0x203e,0x200d,0x1fdd,0x1fac,0x1f7b,0x1f4a,
	0x1f1a,0x1ee9,0x1eb8,0x1e87,0x1e57,0x1e26,0x1df5,0x1dc4,0x1d93,0x1d62,0x1d31,0x1d00,0x1ccf,0x1c9e,0x1c6d,0x1c3c,
	0x1c0b,0x1bda,0x1ba9,0x1b78,0x1b47,0x1b16,0x1ae5,0x1ab4,0x1a82,0x1a51,0x1a20,0x19ef,0x19be,0x198c,0x195b,0x192a,
	0x18f9,0x18c7,0x1896,0x1865,0x1833,0x1802,0x17d0,0x179f,0x176e,0x173c,0x170b,0x16d9,0x16a8,0x1676,0x1645,0x1613,
	0x15e2,0x15b0,0x157f,0x154d,0x151c,0x14ea,0x14b9,0x1487,0x1455,0x1424,0x13f2,0x13c0,0x138f,0x135d,0x132b,0x12fa,
	0x12c8,0x1296,0x1264,0x1233,0x1201,0x11cf,0x119d,0x116c,0x113a,0x1108,0x10d6,0x10a4,0x1072,0x1041,0x100f,0x0fdd,
	0x0fab,0x0f79,0x0f47,0x0f15,0x0ee3,0x0eb1,0x0e80,0x0e4e,0x0e1c,0x0dea,0x0db8,0x0d86,0x0d54,0x0d22,0x0cf0,0x0cbe,
	0x0c8c,0x0c5a,0x0c28,0x0bf6,0x0bc4,0x0b92,0x0b5f,0x0b2d,0x0afb,0x0ac9,0x0a97,0x0a65,0x0a33,0x0a01,0x09cf,0x099d,
	0x096a,0x0938,0x0906,0x08d4,0x08a2,0x0870,0x083e,0x080b,0x07d9,0x07a7,0x0775,0x0743,0x0711,0x06de,0x06ac,0x067a,
	0x0648,0x0616,0x05e3,0x05b1,0x057f,0x054d,0x051b,0x04e8,0x04b6,0x0484,0x0452,0x041f,0x03ed,0x03bb,0x0389,0x0356,
	0x0324,0x02f2,0x02c0,0x028d,0x025b,0x0229,0x01f7,0x01c4,0x0192,0x0160,0x012e,0x00fb,0x00c9,0x0097,0x0065,0x0032,
	0x0000,0xffce,0xff9b,0xff69,0xff37,0xff05,0xfed2,0xfea0,0xfe6e,0xfe3c,0xfe09,0xfdd7,0xfda5,0xfd73,0xfd40,0xfd0e,
	0xfcdc,0xfcaa,0xfc77,0xfc45,0xfc13,0xfbe1,0xfbae,0xfb7c,0xfb4a,0xfb18,0xfae5,0xfab3,0xfa81,0xfa4f,0xfa1d,0xf9ea,
	0xf9b8,0xf986,0xf954,0xf922,0xf8ef,0xf8bd,0xf88b,0xf859,0xf827,0xf7f5,0xf7c2,0xf790,0xf75e,0xf72c,0xf6fa,0xf6c8,
	0xf696,0xf663,0xf631,0xf5ff,0xf5cd,0xf59b,0xf569,0xf537,0xf505,0xf4d3,0xf4a1,0xf46e,0xf43c,0xf40a,0xf3d8,0xf3a6,
	0xf374,0xf342,0xf310,0xf2de,0xf2ac,0xf27a,0xf248,0xf216,0xf1e4,0xf1b2,0xf180,0xf14f,0xf11d,0xf0eb,0xf0b9,0xf087,
	0xf055,0xf023,0xeff1,0xefbf,0xef8e,0xef5c,0xef2a,0xeef8,0xeec6,0xee94,0xee63,0xee31,0xedff,0xedcd,0xed9c,0xed6a,
	0xed38,0xed06,0xecd5,0xeca3,0xec71,0xec40,0xec0e,0xebdc,0xebab,0xeb79,0xeb47,0xeb16,0xeae4,0xeab3,0xea81,0xea50,
	0xea1e,0xe9ed,0xe9bb,0xe98a,0xe958,0xe927,0xe8f5,0xe8c4,0xe892,0xe861,0xe830,0xe7fe,0xe7cd,0xe79b,0xe76a,0xe739,
	0xe707,0xe6d6,0xe6a5,0xe674,0xe642,0xe611,0xe5e0,0xe5af,0xe57e,0xe54c,0xe51b,0xe4ea,0xe4b9,0xe488,0xe457,0xe426,
	0xe3f5,0xe3c4,0xe393,0xe362,0xe331,0xe300,0xe2cf,0xe29e,0xe26d,0xe23c,0xe20b,0xe1da,0xe1a9,0xe179,0xe148,0xe117,
	0xe0e6,0xe0b6,0xe085,0xe054,0xe023,0xdff3,0xdfc2,0xdf91,0xdf61,0xdf30,0xdf00,0xdecf,0xde9f,0xde6e,0xde3e,0xde0d,
	0xdddd,0xddac,0xdd7c,0xdd4b,0xdd1b,0xdceb,0xdcba,0xdc8a,0xdc5a,0xdc29,0xdbf9,0xdbc9,0xdb99,0xdb69,0xdb38,0xdb08,
	0xdad8,0xdaa8,0xda78,0xda48,0xda18,0xd9e8,0xd9b8,0xd988,0xd958,0xd928,0xd8f8,0xd8c9,0xd899,0xd869,0xd839,0xd809,
	0xd7da,0xd7aa,0xd77a,0xd74b,0xd71b,0xd6eb,0xd6bc,0xd68c,0xd65d,0xd62d,0xd5fe,0xd5ce,0xd59f,0xd56f,0xd540,0xd510,
	0xd4e1,0xd4b2,0xd483,0xd453,0xd424,0xd3f5,0xd3c6,0xd396,0xd367,0xd338,0xd309,0xd2da,0xd2ab,0xd27c,0xd24d,0xd21e,
	0xd1ef,0xd1c0,0xd192,0xd163,0xd134,0xd105,0xd0d6,0xd0a8,0xd079,0xd04a,0xd01c,0xcfed,0xcfbf,0xcf90,0xcf62,0xcf33,
	0xcf05,0xced6,0xcea8,0xce79,0xce4b,0xce1d,0xcdef,0xcdc0,0xcd92,0xcd64,0xcd36,0xcd08,0xccda,0xccab,0xcc7d,0xcc4f,
	0xcc21,0xcbf4,0xcbc6,0xcb98,0xcb6a,0xcb3c,0xcb0e,0xcae1,0xcab3,0xca85,0xca58,0xca2a,0xc9fc,0xc9cf,0xc9a1,0xc974,
	0xc946,0xc919,0xc8eb,0xc8be,0xc891,0xc864,0xc836,0xc809,0xc7dc,0xc7af,0xc782,0xc755,0xc727,0xc6fa,0xc6cd,0xc6a0,
	0xc674,0xc647,0xc61a,0xc5ed,0xc5c0,0xc594,0xc567,0xc53a,0xc50e,0xc4e1,0xc4b4,0xc488,0xc45b,0xc42f,0xc402,0xc3d6,
	0xc3aa,0xc37d,0xc351,0xc325,0xc2f9,0xc2cd,0xc2a0,0xc274,0xc248,0xc21c,0xc1f0,0xc1c4,0xc198,0xc16d,0xc141,0xc115,
	0xc0e9,0xc0bd,0xc092,0xc066,0xc03b,0xc00f,0xbfe3,0xbfb8,0xbf8d,0xbf61,0xbf36,0xbf0a,0xbedf,0xbeb4,0xbe89,0xbe5e,
	0xbe32,0xbe07,0xbddc,0xbdb1,0xbd86,0xbd5b,0xbd30,0xbd06,0xbcdb,0xbcb0,0xbc85,0xbc5b,0xbc30,0xbc05,0xbbdb,0xbbb0,
	0xbb86,0xbb5b,0xbb31,0xbb07,0xbadc,0xbab2,0xba88,0xba5d,0xba33,0xba09,0xb9df,0xb9b5,0xb98b,0xb961,0xb937,0xb90d,
	0xb8e4,0xb8ba,0xb890,0xb866,0xb83d,0xb813,0xb7ea,0xb7c0,0xb797,0xb76d,0xb744,0xb71b,0xb6f1,0xb6c8,0xb69f,0xb676,
	0xb64c,0xb623,0xb5fa,0xb5d1,0xb5a8,0xb580,0xb557,0xb52e,0xb505,0xb4dc,0xb4b4,0xb48b,0xb463,0xb43a,0xb412,0xb3e9,
	0xb3c1,0xb398,0xb370,0xb348,0xb320,0xb2f7,0xb2cf,0xb2a7,0xb27f,0xb257,0xb22f,0xb207,0xb1e0,0xb1b8,0xb190,0xb168,
	0xb141,0xb119,0xb0f2,0xb0ca,0xb0a3,0xb07b,0xb054,0xb02c,0xb005,0xafde,0xafb7,0xaf90,0xaf69,0xaf42,0xaf1b,0xaef4,
	0xaecd,0xaea6,0xae7f,0xae58,0xae32,0xae0b,0xade5,0xadbe,0xad98,0xad71,0xad4b,0xad24,0xacfe,0xacd8,0xacb2,0xac8c,
	0xac65,0xac3f,0xac19,0xabf4,0xabce,0xaba8,0xab82,0xab5c,0xab37,0xab11,0xaaeb,0xaac6,0xaaa0,0xaa7b,0xaa56,0xaa30,
	0xaa0b,0xa9e6,0xa9c1,0xa99c,0xa976,0xa951,0xa92d,0xa908,0xa8e3,0xa8be,0xa899,0xa875,0xa850,0xa82b,0xa807,0xa7e2,
	0xa7be,0xa799,0xa775,0xa751,0xa72d,0xa708,0xa6e4,0xa6c0,0xa69c,0xa678,0xa654,0xa631,0xa60d,0xa5e9,0xa5c5,0xa5a2,
	0xa57e,0xa55b,0xa537,0xa514,0xa4f1,0xa4cd,0xa4aa,0xa487,0xa464,0xa441,0xa41e,0xa3fb,0xa3d8,0xa3b5,0xa392,0xa36f,
	0xa34d,0xa32a,0xa307,0xa2e5,0xa2c2,0xa2a0,0xa27e,0xa25b,0xa239,0xa217,0xa1f5,0xa1d3,0xa1b1,0xa18f,0xa16d,0xa14b,
	0xa129,0xa108,0xa0e6,0xa0c4,0xa0a3,0xa081,0xa060,0xa03e,0xa01d,0x9ffc,0x9fdb,0x9fb9,0x9f98,0x9f77,0x9f56,0x9f35,
	0x9f15,0x9ef4,0x9ed3,0x9eb2,0x9e92,0x9e71,0x9e51,0x9e30,0x9e10,0x9def,0x9dcf,0x9daf,0x9d8f,0x9d6f,0x9d4f,0x9d2f,
	0x9d0f,0x9cef,0x9ccf,0x9caf,0x9c90,0x9c70,0x9c51,0x9c31,0x9c12,0x9bf2,0x9bd3,0x9bb4,0x9b94,0x9b75,0x9b56,0x9b37,
	0x9b18,0x9af9,0x9adb,0x9abc,0x9a9d,0x9a7e,0x9a60,0x9a41,0x9a23,0x9a04,0x99e6,0x99c8,0x99aa,0x998b,0x996d,0x994f,
	0x9931,0x9913,0x98f6,0x98d8,0x98ba,0x989c,0x987f,0x9861,0x9844,0x9826,0x9809,0x97ec,0x97ce,0x97b1,0x9794,0x9777,
	0x975a,0x973d,0x9720,0x9704,0x96e7,0x96ca,0x96ae,0x9691,0x9675,0x9658,0x963c,0x9620,0x9603,0x95e7,0x95cb,0x95af,
	0x9593,0x9577,0x955c,0x9540,0x9524,0x9508,0x94ed,0x94d1,0x94b6,0x949b,0x947f,0x9464,0x9449,0x942e,0x9413,0x93f8,
	0x93dd,0x93c2,0x93a7,0x938c,0x9372,0x9357,0x933d,0x9322,0x9308,0x92ed,0x92d3,0x92b9,0x929f,0x9285,0x926b,0x9251,
	0x9237,0x921d,0x9203,0x91ea,0x91d0,0x91b6,0x919d,0x9184,0x916a,0x9151,0x9138,0x911f,0x9105,0x90ec,0x90d4,0x90bb,
	0x90a2,0x9089,0x9070,0x9058,0x903f,0x9027,0x900e,0x8ff6,0x8fde,0x8fc6,0x8fad,0x8f95,0x8f7d,0x8f65,0x8f4e,0x8f36,
	0x8f1e,0x8f06,0x8eef,0x8ed7,0x8ec0,0x8ea8,0x8e91,0x8e7a,0x8e63,0x8e4c,0x8e35,0x8e1e,0x8e07,0x8df0,0x8dd9,0x8dc2,
	0x8dac,0x8d95,0x8d7f,0x8d68,0x8d52,0x8d3c,0x8d25,0x8d0f,0x8cf9,0x8ce3,0x8ccd,0x8cb7,0x8ca2,0x8c8c,0x8c76,0x8c61,
	0x8c4b,0x8c36,0x8c20,0x8c0b,0x8bf6,0x8be0,0x8bcb,0x8bb6,0x8ba1,0x8b8c,0x8b78,0x8b63,0x8b4e,0x8b3a,0x8b25,0x8b10,
	0x8afc,0x8ae8,0x8ad3,0x8abf,0x8aab,0x8a97,0x8a83,0x8a6f,0x8a5b,0x8a48,0x8a34,0x8a20,0x8a0d,0x89f9,0x89e6,0x89d3,
	0x89bf,0x89ac,0x8999,0x8986,0x8973,0x8960,0x894d,0x893a,0x8928,0x8915,0x8902,0x88f0,0x88de,0x88cb,0x88b9,0x88a7,
	0x8895,0x8883,0x8871,0x885f,0x884d,0x883b,0x8829,0x8818,0x8806,0x87f5,0x87e3,0x87d2,0x87c1,0x87b0,0x879e,0x878d,
	0x877c,0x876c,0x875b,0x874a,0x8739,0x8729,0x8718,0x8708,0x86f7,0x86e7,0x86d7,0x86c7,0x86b6,0x86a6,0x8696,0x8687,
	0x8677,0x8667,0x8657,0x8648,0x8638,0x8629,0x861a,0x860a,0x85fb,0x85ec,0x85dd,0x85ce,0x85bf,0x85b0,0x85a1,0x8593,
	0x8584,0x8575,0x8567,0x8558,0x854a,0x853c,0x852e,0x8520,0x8512,0x8504,0x84f6,0x84e8,0x84da,0x84cd,0x84bf,0x84b1,
	0x84a4,0x8497,0x8489,0x847c,0x846f,0x8462,0x8455,0x8448,0x843b,0x842e,0x8422,0x8415,0x8408,0x83fc,0x83f0,0x83e3,
	0x83d7,0x83cb,0x83bf,0x83b3,0x83a7,0x839b,0x838f,0x8383,0x8378,0x836c,0x8361,0x8355,0x834a,0x833f,0x8333,0x8328,
	0x831d,0x8312,0x8307,0x82fc,0x82f2,0x82e7,0x82dc,0x82d2,0x82c7,0x82bd,0x82b3,0x82a9,0x829e,0x8294,0x828a,0x8280,
	0x8277,0x826d,0x8263,0x825a,0x8250,0x8247,0x823d,0x8234,0x822b,0x8221,0x8218,0x820f,0x8206,0x81fe,0x81f5,0x81ec,
	0x81e3,0x81db,0x81d2,0x81ca,0x81c2,0x81b9,0x81b1,0x81a9,0x81a1,0x8199,0x8191,0x8189,0x8182,0x817a,0x8173,0x816b,
	0x8164,0x815c,0x8155,0x814e,0x8147,0x8140,0x8139,0x8132,0x812b,0x8124,0x811e,0x8117,0x8111,0x810a,0x8104,0x80fe,
	0x80f7,0x80f1,0x80eb,0x80e5,0x80df,0x80da,0x80d4,0x80ce,0x80c9,0x80c3,0x80be,0x80b8,0x80b3,0x80ae,0x80a9,0x80a4,
	0x809f,0x809a,0x8095,0x8090,0x808c,0x8087,0x8083,0x807e,0x807a,0x8076,0x8071,0x806d,0x8069,0x8065,0x8061,0x805e,
	0x805a,0x8056,0x8053,0x804f,0x804c,0x8048,0x8045,0x8042,0x803f,0x803c,0x8039,0x8036,0x8033,0x8030,0x802e,0x802b,
	0x8028,0x8026,0x8024,0x8021,0x801f,0x801d,0x801b,0x8019,0x8017,0x8015,0x8014,0x8012,0x8010,0x800f,0x800d,0x800c,
	0x800b,0x800a,0x8009,0x8008,0x8007,0x8006,0x8005,0x8004,0x8003,0x8003,0x8002,0x8002,0x8002,0x8001,0x8001,0x8001,
	0x8001,0x8001,0x8001,0x8001,0x8002,0x8002,0x8002,0x8003,0x8003,0x8004,0x8005,0x8006,0x8007,0x8008,0x8009,0x800a,
	0x800b,0x800c,0x800d,0x800f,0x8010,0x8012,0x8014,0x8015,0x8017,0x8019,0x801b,0x801d,0x801f,0x8021,0x8024,0x8026,
	0x8028,0x802b,0x802e,0x8030,0x8033,0x8036,0x8039,0x803c,0x803f,0x8042,0x8045,0x8048,0x804c,0x804f,0x8053,0x8056,
	0x805a,0x805e,0x8061,0x8065,0x8069,0x806d,0x8071,0x8076,0x807a,0x807e,0x8083,0x8087,0x808c,0x8090,0x8095,0x809a,
	0x809f,0x80a4,0x80a9,0x80ae,0x80b3,0x80b8,0x80be,0x80c3,0x80c9,0x80ce,0x80d4,0x80da,0x80df,0x80e5,0x80eb,0x80f1,
	0x80f7,0x80fe,0x8104,0x810a,0x8111,0x8117,0x811e,0x8124,0x812b,0x8132,0x8139,0x8140,0x8147,0x814e,0x8155,0x815c,
	0x8164,0x816b,0x8173,0x817a,0x8182,0x8189,0x8191,0x8199,0x81a1,0x81a9,0x81b1,0x81b9,0x81c2,0x81ca,0x81d2,0x81db,
	0x81e3,0x81ec,0x81f5,0x81fe,0x8206,0x820f,0x8218,0x8221,0x822b,0x8234,0x823d,0x8247,0x8250,0x825a,0x8263,0x826d,
	0x8277,0x8280,0x828a,0x8294,0x829e,0x82a9,0x82b3,0x82bd,0x82c7,0x82d2,0x82dc,0x82e7,0x82f2,0x82fc,0x8307,0x8312,
	0x831d,0x8328,0x8333,0x833f,0x834a,0x8355,0x8361,0x836c,0x8378,0x8383,0x838f,0x839b,0x83a7,0x83b3,0x83bf,0x83cb,
	0x83d7,0x83e3,0x83f0,0x83fc,0x8408,0x8415,0x8422,0x842e,0x843b,0x8448,0x8455,0x8462,0x846f,0x847c,0x8489,0x8497,
	0x84a4,0x84b1,0x84bf,0x84cd,0x84da,0x84e8,0x84f6,0x8504,0x8512,0x8520,0x852e,0x853c,0x854a,0x8558,0x8567,0x8575,
	0x8584,0x8593,0x85a1,0x85b0,0x85bf,0x85ce,0x85dd,0x85ec,0x85fb,0x860a,0x861a,0x8629,0x8638,0x8648,0x8657,0x8667,
	0x8677,0x8687,0x8696,0x86a6,0x86b6,0x86c7,0x86d7,0x86e7,0x86f7,0x8708,0x8718,0x8729,0x8739,0x874a,0x875b,0x876c,
	0x877c,0x878d,0x879e,0x87b0,0x87c1,0x87d2,0x87e3,0x87f5,0x8806,0x8818,0x8829,0x883b,0x884d,0x885f,0x8871,0x8883,
	0x8895,0x88a7,0x88b9,0x88cb,0x88de,0x88f0,0x8902,0x8915,0x8928,0x893a,0x894d,0x8960,0x8973,0x8986,0x8999,0x89ac,
	0x89bf,0x89d3,0x89e6,0x89f9,0x8a0d,0x8a20,0x8a34,0x8a48,0x8a5b,0x8a6f,0x8a83,0x8a97,0x8aab,0x8abf,0x8ad3,0x8ae8,
	0x8afc,0x8b10,0x8b25,0x8b3a,0x8b4e,0x8b63,0x8b78,0x8b8c,0x8ba1,0x8bb6,0x8bcb,0x8be0,0x8bf6,0x8c0b,0x8c20,0x8c36,
	0x8c4b,0x8c61,0x8c76,0x8c8c,0x8ca2,0x8cb7,0x8ccd,0x8ce3,0x8cf9,0x8d0f,0x8d25,0x8d3c,0x8d52,0x8d68,0x8d7f,0x8d95,
	0x8dac,0x8dc2,0x8dd9,0x8df0,0x8e07,0x8e1e,0x8e35,0x8e4c,0x8e63,0x8e7a,0x8e91,0x8ea8,0x8ec0,0x8ed7,0x8eef,0x8f06,
	0x8f1e,0x8f36,0x8f4e,0x8f65,0x8f7d,0x8f95,0x8fad,0x8fc6,0x8fde,0x8ff6,0x900e,0x9027,0x903f,0x9058,0x9070,0x9089,
	0x90a2,0x90bb,0x90d4,0x90ec,0x9105,0x911f,0x9138,0x9151,0x916a,0x9184,0x919d,0x91b6,0x91d0,0x91ea,0x9203,0x921d,
	0x9237,0x9251,0x926b,0x9285,0x929f,0x92b9,0x92d3,0x92ed,0x9308,0x9322,0x933d,0x9357,0x9372,0x938c,0x93a7,0x93c2,
	0x93dd,0x93f8,0x9413,0x942e,0x9449,0x9464,0x947f,0x949b,0x94b6,0x94d1,0x94ed,0x9508,0x9524,0x9540,0x955c,0x9577,
	0x9593,0x95af,0x95cb,0x95e7,0x9603,0x9620,0x963c,0x9658,0x9675,0x9691,0x96ae,0x96ca,0x96e7,0x9704,0x9720,0x973d,
	0x975a,0x9777,0x9794,0x97b1,0x97ce,0x97ec,0x9809,0x9826,0x9844,0x9861,0x987f,0x989c,0x98ba,0x98d8,0x98f6,0x9913,
	0x9931,0x994f,0x996d,0x998b,0x99aa,0x99c8,0x99e6,0x9a04,0x9a23,0x9a41,0x9a60,0x9a7e,0x9a9d,0x9abc,0x9adb,0x9af9,
	0x9b18,0x9b37,0x9b56,0x9b75,0x9b94,0x9bb4,0x9bd3,0x9bf2,0x9c12,0x9c31,0x9c51,0x9c70,0x9c90,0x9caf,0x9ccf,0x9cef,
	0x9d0f,0x9d2f,0x9d4f,0x9d6f,0x9d8f,0x9daf,0x9dcf,0x9def,0x9e10,0x9e30,0x9e51,0x9e71,0x9e92,0x9eb2,0x9ed3,0x9ef4,
	0x9f15,0x9f35,0x9f56,0x9f77,0x9f98,0x9fb9,0x9fdb,0x9ffc,0xa01d,0xa03e,0xa060,0xa081,0xa0a3,0xa0c4,0xa0e6,0xa108,
	0xa129,0xa14b,0xa16d,0xa18f,0xa1b1,0xa1d3,0xa1f5,0xa217,0xa239,0xa25b,0xa27e,0xa2a0,0xa2c2,0xa2e5,0xa307,0xa32a,
	0xa34d,0xa36f,0xa392,0xa3b5,0xa3d8,0xa3fb,0xa41e,0xa441,0xa464,0xa487,0xa4aa,0xa4cd,0xa4f1,0xa514,0xa537,0xa55b,
	0xa57e,0xa5a2,0xa5c5,0xa5e9,0xa60d,0xa631,0xa654,0xa678,0xa69c,0xa6c0,0xa6e4,0xa708,0xa72d,0xa751,0xa775,0xa799,
	0xa7be,0xa7e2,0xa807,0xa82b,0xa850,0xa875,0xa899,0xa8be,0xa8e3,0xa908,0xa92d,0xa951,0xa976,0xa99c,0xa9c1,0xa9e6,
	0xaa0b,0xaa30,0xaa56,0xaa7b,0xaaa0,0xaac6,0xaaeb,0xab11,0xab37,0xab5c,0xab82,0xaba8,0xabce,0xabf4,0xac19,0xac3f,
	0xac65,0xac8c,0xacb2,0xacd8,0xacfe,0xad24,0xad4b,0xad71,0xad98,0xadbe,0xade5,0xae0b,0xae32,0xae58,0xae7f,0xaea6,
	0xaecd,0xaef4,0xaf1b,0xaf42,0xaf69,0xaf90,0xafb7,0xafde,0xb005,0xb02c,0xb054,0xb07b,0xb0a3,0xb0ca,0xb0f2,0xb119,
	0xb141,0xb168,0xb190,0xb1b8,0xb1e0,0xb207,0xb22f,0xb257,0xb27f,0xb2a7,0xb2cf,0xb2f7,0xb320,0xb348,0xb370,0xb398,
	0xb3c1,0xb3e9,0xb412,0xb43a,0xb463,0xb48b,0xb4b4,0xb4dc,0xb505,0xb52e,0xb557,0xb580,0xb5a8,0xb5d1,0xb5fa,0xb623,
	0xb64c,0xb676,0xb69f,0xb6c8,0xb6f1,0xb71b,0xb744,0xb76d,0xb797,0xb7c0,0xb7ea,0xb813,0xb83d,0xb866,0xb890,0xb8ba,
	0xb8e4,0xb90d,0xb937,0xb961,0xb98b,0xb9b5,0xb9df,0xba09,0xba33,0xba5d,0xba88,0xbab2,0xbadc,0xbb07,0xbb31,0xbb5b,
	0xbb86,0xbbb0,0xbbdb,0xbc05,0xbc30,0xbc5b,0xbc85,0xbcb0,0xbcdb,0xbd06,0xbd30,0xbd5b,0xbd86,0xbdb1,0xbddc,0xbe07,
	0xbe32,0xbe5e,0xbe89,0xbeb4,0xbedf,0xbf0a,0xbf36,0xbf61,0xbf8d,0xbfb8,0xbfe3,0xc00f,0xc03b,0xc066,0xc092,0xc0bd,
	0xc0e9,0xc115,0xc141,0xc16d,0xc198,0xc1c4,0xc1f0,0xc21c,0xc248,0xc274,0xc2a0,0xc2cd,0xc2f9,0xc325,0xc351,0xc37d,
	0xc3aa,0xc3d6,0xc402,0xc42f,0xc45b,0xc488,0xc4b4,0xc4e1,0xc50e,0xc53a,0xc567,0xc594,0xc5c0,0xc5ed,0xc61a,0xc647,
	0xc674,0xc6a0,0xc6cd,0xc6fa,0xc727,0xc755,0xc782,0xc7af,0xc7dc,0xc809,0xc836,0xc864,0xc891,0xc8be,0xc8eb,0xc919,
	0xc946,0xc974,0xc9a1,0xc9cf,0xc9fc,0xca2a,0xca58,0xca85,0xcab3,0xcae1,0xcb0e,0xcb3c,0xcb6a,0xcb98,0xcbc6,0xcbf4,
	0xcc21,0xcc4f,0xcc7d,0xccab,0xccda,0xcd08,0xcd36,0xcd64,0xcd92,0xcdc0,0xcdef,0xce1d,0xce4b,0xce79,0xcea8,0xced6,
	0xcf05,0xcf33,0xcf62,0xcf90,0xcfbf,0xcfed,0xd01c,0xd04a,0xd079,0xd0a8,0xd0d6,0xd105,0xd134,0xd163,0xd192,0xd1c0,
	0xd1ef,0xd21e,0xd24d,0xd27c,0xd2ab,0xd2da,0xd309,0xd338,0xd367,0xd396,0xd3c6,0xd3f5,0xd424,0xd453,0xd483,0xd4b2,
	0xd4e1,0xd510,0xd540,0xd56f,0xd59f,0xd5ce,0xd5fe,0xd62d,0xd65d,0xd68c,0xd6bc,0xd6eb,0xd71b,0xd74b,0xd77a,0xd7aa,
	0xd7da,0xd809,0xd839,0xd869,0xd899,0xd8c9,0xd8f8,0xd928,0xd958,0xd988,0xd9b8,0xd9e8,0xda18,0xda48,0xda78,0xdaa8,
	0xdad8,0xdb08,0xdb38,0xdb69,0xdb99,0xdbc9,0xdbf9,0xdc29,0xdc5a,0xdc8a,0xdcba,0xdceb,0xdd1b,0xdd4b,0xdd7c,0xddac,
	0xdddd,0xde0d,0xde3e,0xde6e,0xde9f,0xdecf,0xdf00,0xdf30,0xdf61,0xdf91,0xdfc2,0xdff3,0xe023,0xe054,0xe085,0xe0b6,
	0xe0e6,0xe117,0xe148,0xe179,0xe1a9,0xe1da,0xe20b,0xe23c,0xe26d,0xe29e,0xe2cf,0xe300,0xe331,0xe362,0xe393,0xe3c4,
	0xe3f5,0xe426,0xe457,0xe488,0xe4b9,0xe4ea,0xe51b,0xe54c,0xe57e,0xe5af,0xe5e0,0xe611,0xe642,0xe674,0xe6a5,0xe6d6,
	0xe707,0xe739,0xe76a,0xe79b,0xe7cd,0xe7fe,0xe830,0xe861,0xe892,0xe8c4,0xe8f5,0xe927,0xe958,0xe98a,0xe9bb,0xe9ed,
	0xea1e,0xea50,0xea81,0xeab3,0xeae4,0xeb16,0xeb47,0xeb79,0xebab,0xebdc,0xec0e,0xec40,0xec71,0xeca3,0xecd5,0xed06,
	0xed38,0xed6a,0xed9c,0xedcd,0xedff,0xee31,0xee63,0xee94,0xeec6,0xeef8,0xef2a,0xef5c,0xef8e,0xefbf,0xeff1,0xf023,
	0xf055,0xf087,0xf0b9,0xf0eb,0xf11d,0xf14f,0xf180,0xf1b2,0xf1e4,0xf216,0xf248,0xf27a,0xf2ac,0xf2de,0xf310,0xf342,
	0xf374,0xf3a6,0xf3d8,0xf40a,0xf43c,0xf46e,0xf4a1,0xf4d3,0xf505,0xf537,0xf569,0xf59b,0xf5cd,0xf5ff,0xf631,0xf663,
	0xf696,0xf6c8,0xf6fa,0xf72c,0xf75e,0xf790,0xf7c2,0xf7f5,0xf827,0xf859,0xf88b,0xf8bd,0xf8ef,0xf922,0xf954,0xf986,
	0xf9b8,0xf9ea,0xfa1d,0xfa4f,0xfa81,0xfab3,0xfae5,0xfb18,0xfb4a,0xfb7c,0xfbae,0xfbe1,0xfc13,0xfc45,0xfc77,0xfcaa,
	0xfcdc,0xfd0e,0xfd40,0xfd73,0xfda5,0xfdd7,0xfe09,0xfe3c,0xfe6e,0xfea0,0xfed2,0xff05,0xff37,0xff69,0xff9b,0xffce,
};

