/*
  printFixedPoint.h 
  Copyright 2014 Marc Prager
 
  This file is part of the c-any library.
  c-any is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 
  c-any is published in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License along with c-any.
  If not see <http://www.gnu.org/licenses/>
 */

/** @file
 * @brief Fixed point decimal output functions.
 *
 */

#ifndef __uint32Div_h
#define __uint32Div_h

#include <integers.h>
#include <fixedPoint.h>
#include <print.h>

#ifdef PROVIDE_MX32_DIV10	// define this, if you want to substitute div by a mul+shift

// prototypes

__attribute__((const)) inline static Uint32 uint32Div10(Uint32 value) {
	enum { e=35, M=3435973837 };
	return (Uint64)value*M >> e;
}

__attribute__((const)) inline static Uint32 uint32Mod10(Uint32 value) {
	return value - 10*uint32Div10(value);

/** Calculates both div (higher 16bits of return value and mod (lower 16bits of return value).
 */
__attribute__((const)) inline static Uint64 uint32DivMod10(Uint32 value) {
	return uint32Div10(value)<<32 | uint32Mod10(value);
}

#else

// let's count on compiler optimizations or a divide instruction of the core...

// 32 bit functions
__attribute__((const)) inline static Uint32 uint32Div10(Uint32 value) {
	return value / 10;
}

__attribute__((const)) inline static Uint32 uint32Mod10(Uint32 value) {
	return value % 10;
}

/** Calculates both div (higher 16bits of return value and mod (lower 16bits of return value).
 */
__attribute__((const)) inline static Uint64 uint32DivMod10(Uint32 value) {
	return (Uint64)uint32Div10(value)<<32 | uint32Mod10(value) % 10;
}

#endif

#endif
