/* Linker script for small assembler executables in FLASH for LPC11xx devices.
 * Startup code omitted.
 *(C) Marc Prager, 2013
 */

OUTPUT_FORMAT("elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)

MEMORY {
	flash (rx)	: ORIGIN = 0x00000000, LENGTH = 16K
	ram (w)		: ORIGIN = 0x10000000, LENGTH = 4K
}

SECTIONS
{
	.text 0x0000	: {
			__text_start = . ;
			*(.text.vectorTable)
			*(.text)
			__text_end = . ;
	} > flash = 0xFFFF



	.rodata 	: {
			__rodata_start = . ;
			*(.rodata*)
			__rodata_end = . ;
			__data_romimage = . ;
	} > flash = 0x0000


	
	.data : AT ( ADDR(.rodata) + SIZEOF(.rodata) ) {
			__data_start = . ;
			*(.data)
			__data_end = . ;
	} > ram = 0x0000 



	.bss		: {
			__bss_start = . ;
			*(.bss) *(COMMON)
			__bss_end = . ;
	} > ram = 0x0000
}

